/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribe.model.AbsoluteTimeRange;
import software.amazon.awssdk.services.transcribe.model.ParticipantRole;
import software.amazon.awssdk.services.transcribe.model.RelativeTimeRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InterruptionFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InterruptionFilter> {
    private static final SdkField<Long> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Threshold").getter(InterruptionFilter.getter(InterruptionFilter::threshold)).setter(InterruptionFilter.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()}).build();
    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantRole").getter(InterruptionFilter.getter(InterruptionFilter::participantRoleAsString)).setter(InterruptionFilter.setter(Builder::participantRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()}).build();
    private static final SdkField<AbsoluteTimeRange> ABSOLUTE_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AbsoluteTimeRange").getter(InterruptionFilter.getter(InterruptionFilter::absoluteTimeRange)).setter(InterruptionFilter.setter(Builder::absoluteTimeRange)).constructor(AbsoluteTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbsoluteTimeRange").build()}).build();
    private static final SdkField<RelativeTimeRange> RELATIVE_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RelativeTimeRange").getter(InterruptionFilter.getter(InterruptionFilter::relativeTimeRange)).setter(InterruptionFilter.setter(Builder::relativeTimeRange)).constructor(RelativeTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativeTimeRange").build()}).build();
    private static final SdkField<Boolean> NEGATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Negate").getter(InterruptionFilter.getter(InterruptionFilter::negate)).setter(InterruptionFilter.setter(Builder::negate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Negate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THRESHOLD_FIELD, PARTICIPANT_ROLE_FIELD, ABSOLUTE_TIME_RANGE_FIELD, RELATIVE_TIME_RANGE_FIELD, NEGATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InterruptionFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long threshold;
    private final String participantRole;
    private final AbsoluteTimeRange absoluteTimeRange;
    private final RelativeTimeRange relativeTimeRange;
    private final Boolean negate;

    private InterruptionFilter(BuilderImpl builder) {
        this.threshold = builder.threshold;
        this.participantRole = builder.participantRole;
        this.absoluteTimeRange = builder.absoluteTimeRange;
        this.relativeTimeRange = builder.relativeTimeRange;
        this.negate = builder.negate;
    }

    public final Long threshold() {
        return this.threshold;
    }

    public final ParticipantRole participantRole() {
        return ParticipantRole.fromValue(this.participantRole);
    }

    public final String participantRoleAsString() {
        return this.participantRole;
    }

    public final AbsoluteTimeRange absoluteTimeRange() {
        return this.absoluteTimeRange;
    }

    public final RelativeTimeRange relativeTimeRange() {
        return this.relativeTimeRange;
    }

    public final Boolean negate() {
        return this.negate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.absoluteTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.relativeTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.negate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InterruptionFilter)) {
            return false;
        }
        InterruptionFilter other = (InterruptionFilter)obj;
        return Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.participantRoleAsString(), other.participantRoleAsString()) && Objects.equals(this.absoluteTimeRange(), other.absoluteTimeRange()) && Objects.equals(this.relativeTimeRange(), other.relativeTimeRange()) && Objects.equals(this.negate(), other.negate());
    }

    public final String toString() {
        return ToString.builder((String)"InterruptionFilter").add("Threshold", (Object)this.threshold()).add("ParticipantRole", (Object)this.participantRoleAsString()).add("AbsoluteTimeRange", (Object)this.absoluteTimeRange()).add("RelativeTimeRange", (Object)this.relativeTimeRange()).add("Negate", (Object)this.negate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "ParticipantRole": {
                return Optional.ofNullable(clazz.cast(this.participantRoleAsString()));
            }
            case "AbsoluteTimeRange": {
                return Optional.ofNullable(clazz.cast(this.absoluteTimeRange()));
            }
            case "RelativeTimeRange": {
                return Optional.ofNullable(clazz.cast(this.relativeTimeRange()));
            }
            case "Negate": {
                return Optional.ofNullable(clazz.cast(this.negate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Threshold", THRESHOLD_FIELD);
        map.put("ParticipantRole", PARTICIPANT_ROLE_FIELD);
        map.put("AbsoluteTimeRange", ABSOLUTE_TIME_RANGE_FIELD);
        map.put("RelativeTimeRange", RELATIVE_TIME_RANGE_FIELD);
        map.put("Negate", NEGATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InterruptionFilter, T> g) {
        return obj -> g.apply((InterruptionFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long threshold;
        private String participantRole;
        private AbsoluteTimeRange absoluteTimeRange;
        private RelativeTimeRange relativeTimeRange;
        private Boolean negate;

        private BuilderImpl() {
        }

        private BuilderImpl(InterruptionFilter model) {
            this.threshold(model.threshold);
            this.participantRole(model.participantRole);
            this.absoluteTimeRange(model.absoluteTimeRange);
            this.relativeTimeRange(model.relativeTimeRange);
            this.negate(model.negate);
        }

        public final Long getThreshold() {
            return this.threshold;
        }

        public final void setThreshold(Long threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Long threshold) {
            this.threshold = threshold;
            return this;
        }

        public final String getParticipantRole() {
            return this.participantRole;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        @Override
        public final Builder participantRole(ParticipantRole participantRole) {
            this.participantRole(participantRole == null ? null : participantRole.toString());
            return this;
        }

        public final AbsoluteTimeRange.Builder getAbsoluteTimeRange() {
            return this.absoluteTimeRange != null ? this.absoluteTimeRange.toBuilder() : null;
        }

        public final void setAbsoluteTimeRange(AbsoluteTimeRange.BuilderImpl absoluteTimeRange) {
            this.absoluteTimeRange = absoluteTimeRange != null ? absoluteTimeRange.build() : null;
        }

        @Override
        public final Builder absoluteTimeRange(AbsoluteTimeRange absoluteTimeRange) {
            this.absoluteTimeRange = absoluteTimeRange;
            return this;
        }

        public final RelativeTimeRange.Builder getRelativeTimeRange() {
            return this.relativeTimeRange != null ? this.relativeTimeRange.toBuilder() : null;
        }

        public final void setRelativeTimeRange(RelativeTimeRange.BuilderImpl relativeTimeRange) {
            this.relativeTimeRange = relativeTimeRange != null ? relativeTimeRange.build() : null;
        }

        @Override
        public final Builder relativeTimeRange(RelativeTimeRange relativeTimeRange) {
            this.relativeTimeRange = relativeTimeRange;
            return this;
        }

        public final Boolean getNegate() {
            return this.negate;
        }

        public final void setNegate(Boolean negate) {
            this.negate = negate;
        }

        @Override
        public final Builder negate(Boolean negate) {
            this.negate = negate;
            return this;
        }

        public InterruptionFilter build() {
            return new InterruptionFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InterruptionFilter> {
        public Builder threshold(Long var1);

        public Builder participantRole(String var1);

        public Builder participantRole(ParticipantRole var1);

        public Builder absoluteTimeRange(AbsoluteTimeRange var1);

        default public Builder absoluteTimeRange(Consumer<AbsoluteTimeRange.Builder> absoluteTimeRange) {
            return this.absoluteTimeRange((AbsoluteTimeRange)((AbsoluteTimeRange.Builder)AbsoluteTimeRange.builder().applyMutation(absoluteTimeRange)).build());
        }

        public Builder relativeTimeRange(RelativeTimeRange var1);

        default public Builder relativeTimeRange(Consumer<RelativeTimeRange.Builder> relativeTimeRange) {
            return this.relativeTimeRange((RelativeTimeRange)((RelativeTimeRange.Builder)RelativeTimeRange.builder().applyMutation(relativeTimeRange)).build());
        }

        public Builder negate(Boolean var1);
    }
}

