/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribe.model.CallAnalyticsFeature;
import software.amazon.awssdk.services.transcribe.model.CallAnalyticsSkippedReasonCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CallAnalyticsSkippedFeature
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CallAnalyticsSkippedFeature> {
    private static final SdkField<String> FEATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Feature").getter(CallAnalyticsSkippedFeature.getter(CallAnalyticsSkippedFeature::featureAsString)).setter(CallAnalyticsSkippedFeature.setter(Builder::feature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feature").build()}).build();
    private static final SdkField<String> REASON_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReasonCode").getter(CallAnalyticsSkippedFeature.getter(CallAnalyticsSkippedFeature::reasonCodeAsString)).setter(CallAnalyticsSkippedFeature.setter(Builder::reasonCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReasonCode").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(CallAnalyticsSkippedFeature.getter(CallAnalyticsSkippedFeature::message)).setter(CallAnalyticsSkippedFeature.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_FIELD, REASON_CODE_FIELD, MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CallAnalyticsSkippedFeature.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String feature;
    private final String reasonCode;
    private final String message;

    private CallAnalyticsSkippedFeature(BuilderImpl builder) {
        this.feature = builder.feature;
        this.reasonCode = builder.reasonCode;
        this.message = builder.message;
    }

    public final CallAnalyticsFeature feature() {
        return CallAnalyticsFeature.fromValue(this.feature);
    }

    public final String featureAsString() {
        return this.feature;
    }

    public final CallAnalyticsSkippedReasonCode reasonCode() {
        return CallAnalyticsSkippedReasonCode.fromValue(this.reasonCode);
    }

    public final String reasonCodeAsString() {
        return this.reasonCode;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.featureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallAnalyticsSkippedFeature)) {
            return false;
        }
        CallAnalyticsSkippedFeature other = (CallAnalyticsSkippedFeature)obj;
        return Objects.equals(this.featureAsString(), other.featureAsString()) && Objects.equals(this.reasonCodeAsString(), other.reasonCodeAsString()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"CallAnalyticsSkippedFeature").add("Feature", (Object)this.featureAsString()).add("ReasonCode", (Object)this.reasonCodeAsString()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Feature": {
                return Optional.ofNullable(clazz.cast(this.featureAsString()));
            }
            case "ReasonCode": {
                return Optional.ofNullable(clazz.cast(this.reasonCodeAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Feature", FEATURE_FIELD);
        map.put("ReasonCode", REASON_CODE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CallAnalyticsSkippedFeature, T> g) {
        return obj -> g.apply((CallAnalyticsSkippedFeature)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String feature;
        private String reasonCode;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(CallAnalyticsSkippedFeature model) {
            this.feature(model.feature);
            this.reasonCode(model.reasonCode);
            this.message(model.message);
        }

        public final String getFeature() {
            return this.feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public final Builder feature(CallAnalyticsFeature feature) {
            this.feature(feature == null ? null : feature.toString());
            return this;
        }

        public final String getReasonCode() {
            return this.reasonCode;
        }

        public final void setReasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
        }

        @Override
        public final Builder reasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        @Override
        public final Builder reasonCode(CallAnalyticsSkippedReasonCode reasonCode) {
            this.reasonCode(reasonCode == null ? null : reasonCode.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public CallAnalyticsSkippedFeature build() {
            return new CallAnalyticsSkippedFeature(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CallAnalyticsSkippedFeature> {
        public Builder feature(String var1);

        public Builder feature(CallAnalyticsFeature var1);

        public Builder reasonCode(String var1);

        public Builder reasonCode(CallAnalyticsSkippedReasonCode var1);

        public Builder message(String var1);
    }
}

