/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.ToxicityCategoriesCopier;
import software.amazon.awssdk.services.transcribe.model.ToxicityCategory;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ToxicityDetectionSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ToxicityDetectionSettings> {
    private static final SdkField<List<String>> TOXICITY_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ToxicityCategories").getter(ToxicityDetectionSettings.getter(ToxicityDetectionSettings::toxicityCategoriesAsStrings)).setter(ToxicityDetectionSettings.setter(Builder::toxicityCategoriesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToxicityCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOXICITY_CATEGORIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ToxicityDetectionSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> toxicityCategories;

    private ToxicityDetectionSettings(BuilderImpl builder) {
        this.toxicityCategories = builder.toxicityCategories;
    }

    public final List<ToxicityCategory> toxicityCategories() {
        return ToxicityCategoriesCopier.copyStringToEnum(this.toxicityCategories);
    }

    public final boolean hasToxicityCategories() {
        return this.toxicityCategories != null && !(this.toxicityCategories instanceof SdkAutoConstructList);
    }

    public final List<String> toxicityCategoriesAsStrings() {
        return this.toxicityCategories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasToxicityCategories() ? this.toxicityCategoriesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToxicityDetectionSettings)) {
            return false;
        }
        ToxicityDetectionSettings other = (ToxicityDetectionSettings)obj;
        return this.hasToxicityCategories() == other.hasToxicityCategories() && Objects.equals(this.toxicityCategoriesAsStrings(), other.toxicityCategoriesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ToxicityDetectionSettings").add("ToxicityCategories", this.hasToxicityCategories() ? this.toxicityCategoriesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ToxicityCategories": {
                return Optional.ofNullable(clazz.cast(this.toxicityCategoriesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("ToxicityCategories", TOXICITY_CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToxicityDetectionSettings, T> g) {
        return obj -> g.apply((ToxicityDetectionSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> toxicityCategories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ToxicityDetectionSettings model) {
            this.toxicityCategoriesWithStrings(model.toxicityCategories);
        }

        public final Collection<String> getToxicityCategories() {
            if (this.toxicityCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.toxicityCategories;
        }

        public final void setToxicityCategories(Collection<String> toxicityCategories) {
            this.toxicityCategories = ToxicityCategoriesCopier.copy(toxicityCategories);
        }

        @Override
        public final Builder toxicityCategoriesWithStrings(Collection<String> toxicityCategories) {
            this.toxicityCategories = ToxicityCategoriesCopier.copy(toxicityCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toxicityCategoriesWithStrings(String ... toxicityCategories) {
            this.toxicityCategoriesWithStrings(Arrays.asList(toxicityCategories));
            return this;
        }

        @Override
        public final Builder toxicityCategories(Collection<ToxicityCategory> toxicityCategories) {
            this.toxicityCategories = ToxicityCategoriesCopier.copyEnumToString(toxicityCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toxicityCategories(ToxicityCategory ... toxicityCategories) {
            this.toxicityCategories(Arrays.asList(toxicityCategories));
            return this;
        }

        public ToxicityDetectionSettings build() {
            return new ToxicityDetectionSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ToxicityDetectionSettings> {
        public Builder toxicityCategoriesWithStrings(Collection<String> var1);

        public Builder toxicityCategoriesWithStrings(String ... var1);

        public Builder toxicityCategories(Collection<ToxicityCategory> var1);

        public Builder toxicityCategories(ToxicityCategory ... var1);
    }
}

