/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CsvConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CsvConfiguration> {
    private static final SdkField<String> COLUMN_SEPARATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColumnSeparator").getter(CsvConfiguration.getter(CsvConfiguration::columnSeparator)).setter(CsvConfiguration.setter(Builder::columnSeparator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnSeparator").build()}).build();
    private static final SdkField<String> ESCAPE_CHAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EscapeChar").getter(CsvConfiguration.getter(CsvConfiguration::escapeChar)).setter(CsvConfiguration.setter(Builder::escapeChar)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EscapeChar").build()}).build();
    private static final SdkField<String> QUOTE_CHAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuoteChar").getter(CsvConfiguration.getter(CsvConfiguration::quoteChar)).setter(CsvConfiguration.setter(Builder::quoteChar)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuoteChar").build()}).build();
    private static final SdkField<String> NULL_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NullValue").getter(CsvConfiguration.getter(CsvConfiguration::nullValue)).setter(CsvConfiguration.setter(Builder::nullValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullValue").build()}).build();
    private static final SdkField<Boolean> TRIM_WHITE_SPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TrimWhiteSpace").getter(CsvConfiguration.getter(CsvConfiguration::trimWhiteSpace)).setter(CsvConfiguration.setter(Builder::trimWhiteSpace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrimWhiteSpace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_SEPARATOR_FIELD, ESCAPE_CHAR_FIELD, QUOTE_CHAR_FIELD, NULL_VALUE_FIELD, TRIM_WHITE_SPACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CsvConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String columnSeparator;
    private final String escapeChar;
    private final String quoteChar;
    private final String nullValue;
    private final Boolean trimWhiteSpace;

    private CsvConfiguration(BuilderImpl builder) {
        this.columnSeparator = builder.columnSeparator;
        this.escapeChar = builder.escapeChar;
        this.quoteChar = builder.quoteChar;
        this.nullValue = builder.nullValue;
        this.trimWhiteSpace = builder.trimWhiteSpace;
    }

    public final String columnSeparator() {
        return this.columnSeparator;
    }

    public final String escapeChar() {
        return this.escapeChar;
    }

    public final String quoteChar() {
        return this.quoteChar;
    }

    public final String nullValue() {
        return this.nullValue;
    }

    public final Boolean trimWhiteSpace() {
        return this.trimWhiteSpace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.columnSeparator());
        hashCode = 31 * hashCode + Objects.hashCode(this.escapeChar());
        hashCode = 31 * hashCode + Objects.hashCode(this.quoteChar());
        hashCode = 31 * hashCode + Objects.hashCode(this.nullValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.trimWhiteSpace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CsvConfiguration)) {
            return false;
        }
        CsvConfiguration other = (CsvConfiguration)obj;
        return Objects.equals(this.columnSeparator(), other.columnSeparator()) && Objects.equals(this.escapeChar(), other.escapeChar()) && Objects.equals(this.quoteChar(), other.quoteChar()) && Objects.equals(this.nullValue(), other.nullValue()) && Objects.equals(this.trimWhiteSpace(), other.trimWhiteSpace());
    }

    public final String toString() {
        return ToString.builder((String)"CsvConfiguration").add("ColumnSeparator", (Object)this.columnSeparator()).add("EscapeChar", (Object)this.escapeChar()).add("QuoteChar", (Object)this.quoteChar()).add("NullValue", (Object)this.nullValue()).add("TrimWhiteSpace", (Object)this.trimWhiteSpace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColumnSeparator": {
                return Optional.ofNullable(clazz.cast(this.columnSeparator()));
            }
            case "EscapeChar": {
                return Optional.ofNullable(clazz.cast(this.escapeChar()));
            }
            case "QuoteChar": {
                return Optional.ofNullable(clazz.cast(this.quoteChar()));
            }
            case "NullValue": {
                return Optional.ofNullable(clazz.cast(this.nullValue()));
            }
            case "TrimWhiteSpace": {
                return Optional.ofNullable(clazz.cast(this.trimWhiteSpace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ColumnSeparator", COLUMN_SEPARATOR_FIELD);
        map.put("EscapeChar", ESCAPE_CHAR_FIELD);
        map.put("QuoteChar", QUOTE_CHAR_FIELD);
        map.put("NullValue", NULL_VALUE_FIELD);
        map.put("TrimWhiteSpace", TRIM_WHITE_SPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CsvConfiguration, T> g) {
        return obj -> g.apply((CsvConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String columnSeparator;
        private String escapeChar;
        private String quoteChar;
        private String nullValue;
        private Boolean trimWhiteSpace;

        private BuilderImpl() {
        }

        private BuilderImpl(CsvConfiguration model) {
            this.columnSeparator(model.columnSeparator);
            this.escapeChar(model.escapeChar);
            this.quoteChar(model.quoteChar);
            this.nullValue(model.nullValue);
            this.trimWhiteSpace(model.trimWhiteSpace);
        }

        public final String getColumnSeparator() {
            return this.columnSeparator;
        }

        public final void setColumnSeparator(String columnSeparator) {
            this.columnSeparator = columnSeparator;
        }

        @Override
        public final Builder columnSeparator(String columnSeparator) {
            this.columnSeparator = columnSeparator;
            return this;
        }

        public final String getEscapeChar() {
            return this.escapeChar;
        }

        public final void setEscapeChar(String escapeChar) {
            this.escapeChar = escapeChar;
        }

        @Override
        public final Builder escapeChar(String escapeChar) {
            this.escapeChar = escapeChar;
            return this;
        }

        public final String getQuoteChar() {
            return this.quoteChar;
        }

        public final void setQuoteChar(String quoteChar) {
            this.quoteChar = quoteChar;
        }

        @Override
        public final Builder quoteChar(String quoteChar) {
            this.quoteChar = quoteChar;
            return this;
        }

        public final String getNullValue() {
            return this.nullValue;
        }

        public final void setNullValue(String nullValue) {
            this.nullValue = nullValue;
        }

        @Override
        public final Builder nullValue(String nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        public final Boolean getTrimWhiteSpace() {
            return this.trimWhiteSpace;
        }

        public final void setTrimWhiteSpace(Boolean trimWhiteSpace) {
            this.trimWhiteSpace = trimWhiteSpace;
        }

        @Override
        public final Builder trimWhiteSpace(Boolean trimWhiteSpace) {
            this.trimWhiteSpace = trimWhiteSpace;
            return this;
        }

        public CsvConfiguration build() {
            return new CsvConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CsvConfiguration> {
        public Builder columnSeparator(String var1);

        public Builder escapeChar(String var1);

        public Builder quoteChar(String var1);

        public Builder nullValue(String var1);

        public Builder trimWhiteSpace(Boolean var1);
    }
}

