/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreamwrite.model.BatchLoadDataFormat;
import software.amazon.awssdk.services.timestreamwrite.model.CsvConfiguration;
import software.amazon.awssdk.services.timestreamwrite.model.DataSourceS3Configuration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceConfiguration> {
    private static final SdkField<DataSourceS3Configuration> DATA_SOURCE_S3_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSourceS3Configuration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::dataSourceS3Configuration)).setter(DataSourceConfiguration.setter(Builder::dataSourceS3Configuration)).constructor(DataSourceS3Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceS3Configuration").build()}).build();
    private static final SdkField<CsvConfiguration> CSV_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CsvConfiguration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::csvConfiguration)).setter(DataSourceConfiguration.setter(Builder::csvConfiguration)).constructor(CsvConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvConfiguration").build()}).build();
    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataFormat").getter(DataSourceConfiguration.getter(DataSourceConfiguration::dataFormatAsString)).setter(DataSourceConfiguration.setter(Builder::dataFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_S3_CONFIGURATION_FIELD, CSV_CONFIGURATION_FIELD, DATA_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSourceConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DataSourceS3Configuration dataSourceS3Configuration;
    private final CsvConfiguration csvConfiguration;
    private final String dataFormat;

    private DataSourceConfiguration(BuilderImpl builder) {
        this.dataSourceS3Configuration = builder.dataSourceS3Configuration;
        this.csvConfiguration = builder.csvConfiguration;
        this.dataFormat = builder.dataFormat;
    }

    public final DataSourceS3Configuration dataSourceS3Configuration() {
        return this.dataSourceS3Configuration;
    }

    public final CsvConfiguration csvConfiguration() {
        return this.csvConfiguration;
    }

    public final BatchLoadDataFormat dataFormat() {
        return BatchLoadDataFormat.fromValue(this.dataFormat);
    }

    public final String dataFormatAsString() {
        return this.dataFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceS3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.csvConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfiguration)) {
            return false;
        }
        DataSourceConfiguration other = (DataSourceConfiguration)obj;
        return Objects.equals(this.dataSourceS3Configuration(), other.dataSourceS3Configuration()) && Objects.equals(this.csvConfiguration(), other.csvConfiguration()) && Objects.equals(this.dataFormatAsString(), other.dataFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourceConfiguration").add("DataSourceS3Configuration", (Object)this.dataSourceS3Configuration()).add("CsvConfiguration", (Object)this.csvConfiguration()).add("DataFormat", (Object)this.dataFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceS3Configuration": {
                return Optional.ofNullable(clazz.cast(this.dataSourceS3Configuration()));
            }
            case "CsvConfiguration": {
                return Optional.ofNullable(clazz.cast(this.csvConfiguration()));
            }
            case "DataFormat": {
                return Optional.ofNullable(clazz.cast(this.dataFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataSourceS3Configuration", DATA_SOURCE_S3_CONFIGURATION_FIELD);
        map.put("CsvConfiguration", CSV_CONFIGURATION_FIELD);
        map.put("DataFormat", DATA_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceConfiguration, T> g) {
        return obj -> g.apply((DataSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataSourceS3Configuration dataSourceS3Configuration;
        private CsvConfiguration csvConfiguration;
        private String dataFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceConfiguration model) {
            this.dataSourceS3Configuration(model.dataSourceS3Configuration);
            this.csvConfiguration(model.csvConfiguration);
            this.dataFormat(model.dataFormat);
        }

        public final DataSourceS3Configuration.Builder getDataSourceS3Configuration() {
            return this.dataSourceS3Configuration != null ? this.dataSourceS3Configuration.toBuilder() : null;
        }

        public final void setDataSourceS3Configuration(DataSourceS3Configuration.BuilderImpl dataSourceS3Configuration) {
            this.dataSourceS3Configuration = dataSourceS3Configuration != null ? dataSourceS3Configuration.build() : null;
        }

        @Override
        public final Builder dataSourceS3Configuration(DataSourceS3Configuration dataSourceS3Configuration) {
            this.dataSourceS3Configuration = dataSourceS3Configuration;
            return this;
        }

        public final CsvConfiguration.Builder getCsvConfiguration() {
            return this.csvConfiguration != null ? this.csvConfiguration.toBuilder() : null;
        }

        public final void setCsvConfiguration(CsvConfiguration.BuilderImpl csvConfiguration) {
            this.csvConfiguration = csvConfiguration != null ? csvConfiguration.build() : null;
        }

        @Override
        public final Builder csvConfiguration(CsvConfiguration csvConfiguration) {
            this.csvConfiguration = csvConfiguration;
            return this;
        }

        public final String getDataFormat() {
            return this.dataFormat;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(BatchLoadDataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public DataSourceConfiguration build() {
            return new DataSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceConfiguration> {
        public Builder dataSourceS3Configuration(DataSourceS3Configuration var1);

        default public Builder dataSourceS3Configuration(Consumer<DataSourceS3Configuration.Builder> dataSourceS3Configuration) {
            return this.dataSourceS3Configuration((DataSourceS3Configuration)((DataSourceS3Configuration.Builder)DataSourceS3Configuration.builder().applyMutation(dataSourceS3Configuration)).build());
        }

        public Builder csvConfiguration(CsvConfiguration var1);

        default public Builder csvConfiguration(Consumer<CsvConfiguration.Builder> csvConfiguration) {
            return this.csvConfiguration((CsvConfiguration)((CsvConfiguration.Builder)CsvConfiguration.builder().applyMutation(csvConfiguration)).build());
        }

        public Builder dataFormat(String var1);

        public Builder dataFormat(BatchLoadDataFormat var1);
    }
}

