/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The set of properties on a table for configuring magnetic store writes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MagneticStoreWriteProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<MagneticStoreWriteProperties.Builder, MagneticStoreWriteProperties> {
    private static final SdkField<Boolean> ENABLE_MAGNETIC_STORE_WRITES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("EnableMagneticStoreWrites")
            .getter(getter(MagneticStoreWriteProperties::enableMagneticStoreWrites))
            .setter(setter(Builder::enableMagneticStoreWrites))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableMagneticStoreWrites").build())
            .build();

    private static final SdkField<MagneticStoreRejectedDataLocation> MAGNETIC_STORE_REJECTED_DATA_LOCATION_FIELD = SdkField
            .<MagneticStoreRejectedDataLocation> builder(MarshallingType.SDK_POJO)
            .memberName("MagneticStoreRejectedDataLocation")
            .getter(getter(MagneticStoreWriteProperties::magneticStoreRejectedDataLocation))
            .setter(setter(Builder::magneticStoreRejectedDataLocation))
            .constructor(MagneticStoreRejectedDataLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MagneticStoreRejectedDataLocation")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENABLE_MAGNETIC_STORE_WRITES_FIELD, MAGNETIC_STORE_REJECTED_DATA_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enableMagneticStoreWrites;

    private final MagneticStoreRejectedDataLocation magneticStoreRejectedDataLocation;

    private MagneticStoreWriteProperties(BuilderImpl builder) {
        this.enableMagneticStoreWrites = builder.enableMagneticStoreWrites;
        this.magneticStoreRejectedDataLocation = builder.magneticStoreRejectedDataLocation;
    }

    /**
     * <p>
     * A flag to enable magnetic store writes.
     * </p>
     * 
     * @return A flag to enable magnetic store writes.
     */
    public final Boolean enableMagneticStoreWrites() {
        return enableMagneticStoreWrites;
    }

    /**
     * <p>
     * The location to write error reports for records rejected asynchronously during magnetic store writes.
     * </p>
     * 
     * @return The location to write error reports for records rejected asynchronously during magnetic store writes.
     */
    public final MagneticStoreRejectedDataLocation magneticStoreRejectedDataLocation() {
        return magneticStoreRejectedDataLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableMagneticStoreWrites());
        hashCode = 31 * hashCode + Objects.hashCode(magneticStoreRejectedDataLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MagneticStoreWriteProperties)) {
            return false;
        }
        MagneticStoreWriteProperties other = (MagneticStoreWriteProperties) obj;
        return Objects.equals(enableMagneticStoreWrites(), other.enableMagneticStoreWrites())
                && Objects.equals(magneticStoreRejectedDataLocation(), other.magneticStoreRejectedDataLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MagneticStoreWriteProperties").add("EnableMagneticStoreWrites", enableMagneticStoreWrites())
                .add("MagneticStoreRejectedDataLocation", magneticStoreRejectedDataLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableMagneticStoreWrites":
            return Optional.ofNullable(clazz.cast(enableMagneticStoreWrites()));
        case "MagneticStoreRejectedDataLocation":
            return Optional.ofNullable(clazz.cast(magneticStoreRejectedDataLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MagneticStoreWriteProperties, T> g) {
        return obj -> g.apply((MagneticStoreWriteProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MagneticStoreWriteProperties> {
        /**
         * <p>
         * A flag to enable magnetic store writes.
         * </p>
         * 
         * @param enableMagneticStoreWrites
         *        A flag to enable magnetic store writes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableMagneticStoreWrites(Boolean enableMagneticStoreWrites);

        /**
         * <p>
         * The location to write error reports for records rejected asynchronously during magnetic store writes.
         * </p>
         * 
         * @param magneticStoreRejectedDataLocation
         *        The location to write error reports for records rejected asynchronously during magnetic store writes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder magneticStoreRejectedDataLocation(MagneticStoreRejectedDataLocation magneticStoreRejectedDataLocation);

        /**
         * <p>
         * The location to write error reports for records rejected asynchronously during magnetic store writes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MagneticStoreRejectedDataLocation.Builder} avoiding the need to create one manually via
         * {@link MagneticStoreRejectedDataLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MagneticStoreRejectedDataLocation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #magneticStoreRejectedDataLocation(MagneticStoreRejectedDataLocation)}.
         * 
         * @param magneticStoreRejectedDataLocation
         *        a consumer that will call methods on {@link MagneticStoreRejectedDataLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #magneticStoreRejectedDataLocation(MagneticStoreRejectedDataLocation)
         */
        default Builder magneticStoreRejectedDataLocation(
                Consumer<MagneticStoreRejectedDataLocation.Builder> magneticStoreRejectedDataLocation) {
            return magneticStoreRejectedDataLocation(MagneticStoreRejectedDataLocation.builder()
                    .applyMutation(magneticStoreRejectedDataLocation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableMagneticStoreWrites;

        private MagneticStoreRejectedDataLocation magneticStoreRejectedDataLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(MagneticStoreWriteProperties model) {
            enableMagneticStoreWrites(model.enableMagneticStoreWrites);
            magneticStoreRejectedDataLocation(model.magneticStoreRejectedDataLocation);
        }

        public final Boolean getEnableMagneticStoreWrites() {
            return enableMagneticStoreWrites;
        }

        public final void setEnableMagneticStoreWrites(Boolean enableMagneticStoreWrites) {
            this.enableMagneticStoreWrites = enableMagneticStoreWrites;
        }

        @Override
        public final Builder enableMagneticStoreWrites(Boolean enableMagneticStoreWrites) {
            this.enableMagneticStoreWrites = enableMagneticStoreWrites;
            return this;
        }

        public final MagneticStoreRejectedDataLocation.Builder getMagneticStoreRejectedDataLocation() {
            return magneticStoreRejectedDataLocation != null ? magneticStoreRejectedDataLocation.toBuilder() : null;
        }

        public final void setMagneticStoreRejectedDataLocation(
                MagneticStoreRejectedDataLocation.BuilderImpl magneticStoreRejectedDataLocation) {
            this.magneticStoreRejectedDataLocation = magneticStoreRejectedDataLocation != null ? magneticStoreRejectedDataLocation
                    .build() : null;
        }

        @Override
        public final Builder magneticStoreRejectedDataLocation(MagneticStoreRejectedDataLocation magneticStoreRejectedDataLocation) {
            this.magneticStoreRejectedDataLocation = magneticStoreRejectedDataLocation;
            return this;
        }

        @Override
        public MagneticStoreWriteProperties build() {
            return new MagneticStoreWriteProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
