/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a batch load task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchLoadTask implements SdkPojo, Serializable, ToCopyableBuilder<BatchLoadTask.Builder, BatchLoadTask> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TaskId")
            .getter(getter(BatchLoadTask::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskId").build()).build();

    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskStatus").getter(getter(BatchLoadTask::taskStatusAsString)).setter(setter(Builder::taskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskStatus").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(BatchLoadTask::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(BatchLoadTask::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(BatchLoadTask::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(BatchLoadTask::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<Instant> RESUMABLE_UNTIL_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ResumableUntil").getter(getter(BatchLoadTask::resumableUntil)).setter(setter(Builder::resumableUntil))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResumableUntil").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD,
            TASK_STATUS_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD,
            RESUMABLE_UNTIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String taskId;

    private final String taskStatus;

    private final String databaseName;

    private final String tableName;

    private final Instant creationTime;

    private final Instant lastUpdatedTime;

    private final Instant resumableUntil;

    private BatchLoadTask(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.taskStatus = builder.taskStatus;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.resumableUntil = builder.resumableUntil;
    }

    /**
     * <p>
     * The ID of the batch load task.
     * </p>
     * 
     * @return The ID of the batch load task.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * Status of the batch load task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link BatchLoadStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskStatusAsString}.
     * </p>
     * 
     * @return Status of the batch load task.
     * @see BatchLoadStatus
     */
    public final BatchLoadStatus taskStatus() {
        return BatchLoadStatus.fromValue(taskStatus);
    }

    /**
     * <p>
     * Status of the batch load task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link BatchLoadStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskStatusAsString}.
     * </p>
     * 
     * @return Status of the batch load task.
     * @see BatchLoadStatus
     */
    public final String taskStatusAsString() {
        return taskStatus;
    }

    /**
     * <p>
     * Database name for the database into which a batch load task loads data.
     * </p>
     * 
     * @return Database name for the database into which a batch load task loads data.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * Table name for the table into which a batch load task loads data.
     * </p>
     * 
     * @return Table name for the table into which a batch load task loads data.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The time when the Timestream batch load task was created.
     * </p>
     * 
     * @return The time when the Timestream batch load task was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time when the Timestream batch load task was last updated.
     * </p>
     * 
     * @return The time when the Timestream batch load task was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * </p>
     * 
     * @return
     */
    public final Instant resumableUntil() {
        return resumableUntil;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(resumableUntil());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchLoadTask)) {
            return false;
        }
        BatchLoadTask other = (BatchLoadTask) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(taskStatusAsString(), other.taskStatusAsString())
                && Objects.equals(databaseName(), other.databaseName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(resumableUntil(), other.resumableUntil());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchLoadTask").add("TaskId", taskId()).add("TaskStatus", taskStatusAsString())
                .add("DatabaseName", databaseName()).add("TableName", tableName()).add("CreationTime", creationTime())
                .add("LastUpdatedTime", lastUpdatedTime()).add("ResumableUntil", resumableUntil()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "TaskStatus":
            return Optional.ofNullable(clazz.cast(taskStatusAsString()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "ResumableUntil":
            return Optional.ofNullable(clazz.cast(resumableUntil()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchLoadTask, T> g) {
        return obj -> g.apply((BatchLoadTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchLoadTask> {
        /**
         * <p>
         * The ID of the batch load task.
         * </p>
         * 
         * @param taskId
         *        The ID of the batch load task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * Status of the batch load task.
         * </p>
         * 
         * @param taskStatus
         *        Status of the batch load task.
         * @see BatchLoadStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchLoadStatus
         */
        Builder taskStatus(String taskStatus);

        /**
         * <p>
         * Status of the batch load task.
         * </p>
         * 
         * @param taskStatus
         *        Status of the batch load task.
         * @see BatchLoadStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchLoadStatus
         */
        Builder taskStatus(BatchLoadStatus taskStatus);

        /**
         * <p>
         * Database name for the database into which a batch load task loads data.
         * </p>
         * 
         * @param databaseName
         *        Database name for the database into which a batch load task loads data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * Table name for the table into which a batch load task loads data.
         * </p>
         * 
         * @param tableName
         *        Table name for the table into which a batch load task loads data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The time when the Timestream batch load task was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the Timestream batch load task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time when the Timestream batch load task was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time when the Timestream batch load task was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * </p>
         * 
         * @param resumableUntil
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resumableUntil(Instant resumableUntil);
    }

    static final class BuilderImpl implements Builder {
        private String taskId;

        private String taskStatus;

        private String databaseName;

        private String tableName;

        private Instant creationTime;

        private Instant lastUpdatedTime;

        private Instant resumableUntil;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchLoadTask model) {
            taskId(model.taskId);
            taskStatus(model.taskStatus);
            databaseName(model.databaseName);
            tableName(model.tableName);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
            resumableUntil(model.resumableUntil);
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getTaskStatus() {
            return taskStatus;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(BatchLoadStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Instant getResumableUntil() {
            return resumableUntil;
        }

        public final void setResumableUntil(Instant resumableUntil) {
            this.resumableUntil = resumableUntil;
        }

        @Override
        public final Builder resumableUntil(Instant resumableUntil) {
            this.resumableUntil = resumableUntil;
            return this;
        }

        @Override
        public BatchLoadTask build() {
            return new BatchLoadTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
