/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetentionProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetentionProperties> {
    private static final SdkField<Long> MEMORY_STORE_RETENTION_PERIOD_IN_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MemoryStoreRetentionPeriodInHours").getter(RetentionProperties.getter(RetentionProperties::memoryStoreRetentionPeriodInHours)).setter(RetentionProperties.setter(Builder::memoryStoreRetentionPeriodInHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryStoreRetentionPeriodInHours").build()}).build();
    private static final SdkField<Long> MAGNETIC_STORE_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MagneticStoreRetentionPeriodInDays").getter(RetentionProperties.getter(RetentionProperties::magneticStoreRetentionPeriodInDays)).setter(RetentionProperties.setter(Builder::magneticStoreRetentionPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MagneticStoreRetentionPeriodInDays").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_STORE_RETENTION_PERIOD_IN_HOURS_FIELD, MAGNETIC_STORE_RETENTION_PERIOD_IN_DAYS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long memoryStoreRetentionPeriodInHours;
    private final Long magneticStoreRetentionPeriodInDays;

    private RetentionProperties(BuilderImpl builder) {
        this.memoryStoreRetentionPeriodInHours = builder.memoryStoreRetentionPeriodInHours;
        this.magneticStoreRetentionPeriodInDays = builder.magneticStoreRetentionPeriodInDays;
    }

    public final Long memoryStoreRetentionPeriodInHours() {
        return this.memoryStoreRetentionPeriodInHours;
    }

    public final Long magneticStoreRetentionPeriodInDays() {
        return this.magneticStoreRetentionPeriodInDays;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryStoreRetentionPeriodInHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.magneticStoreRetentionPeriodInDays());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetentionProperties)) {
            return false;
        }
        RetentionProperties other = (RetentionProperties)obj;
        return Objects.equals(this.memoryStoreRetentionPeriodInHours(), other.memoryStoreRetentionPeriodInHours()) && Objects.equals(this.magneticStoreRetentionPeriodInDays(), other.magneticStoreRetentionPeriodInDays());
    }

    public final String toString() {
        return ToString.builder((String)"RetentionProperties").add("MemoryStoreRetentionPeriodInHours", (Object)this.memoryStoreRetentionPeriodInHours()).add("MagneticStoreRetentionPeriodInDays", (Object)this.magneticStoreRetentionPeriodInDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MemoryStoreRetentionPeriodInHours": {
                return Optional.ofNullable(clazz.cast(this.memoryStoreRetentionPeriodInHours()));
            }
            case "MagneticStoreRetentionPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.magneticStoreRetentionPeriodInDays()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetentionProperties, T> g) {
        return obj -> g.apply((RetentionProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long memoryStoreRetentionPeriodInHours;
        private Long magneticStoreRetentionPeriodInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(RetentionProperties model) {
            this.memoryStoreRetentionPeriodInHours(model.memoryStoreRetentionPeriodInHours);
            this.magneticStoreRetentionPeriodInDays(model.magneticStoreRetentionPeriodInDays);
        }

        public final Long getMemoryStoreRetentionPeriodInHours() {
            return this.memoryStoreRetentionPeriodInHours;
        }

        public final void setMemoryStoreRetentionPeriodInHours(Long memoryStoreRetentionPeriodInHours) {
            this.memoryStoreRetentionPeriodInHours = memoryStoreRetentionPeriodInHours;
        }

        @Override
        public final Builder memoryStoreRetentionPeriodInHours(Long memoryStoreRetentionPeriodInHours) {
            this.memoryStoreRetentionPeriodInHours = memoryStoreRetentionPeriodInHours;
            return this;
        }

        public final Long getMagneticStoreRetentionPeriodInDays() {
            return this.magneticStoreRetentionPeriodInDays;
        }

        public final void setMagneticStoreRetentionPeriodInDays(Long magneticStoreRetentionPeriodInDays) {
            this.magneticStoreRetentionPeriodInDays = magneticStoreRetentionPeriodInDays;
        }

        @Override
        public final Builder magneticStoreRetentionPeriodInDays(Long magneticStoreRetentionPeriodInDays) {
            this.magneticStoreRetentionPeriodInDays = magneticStoreRetentionPeriodInDays;
            return this;
        }

        public RetentionProperties build() {
            return new RetentionProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetentionProperties> {
        public Builder memoryStoreRetentionPeriodInHours(Long var1);

        public Builder magneticStoreRetentionPeriodInDays(Long var1);
    }
}

