/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryAsyncClient;
import software.amazon.awssdk.services.timestreamquery.internal.UserAgentUtils;
import software.amazon.awssdk.services.timestreamquery.model.QueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.QueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.Row;

public class QueryPublisher
implements SdkPublisher<QueryResponse> {
    private final TimestreamQueryAsyncClient client;
    private final QueryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public QueryPublisher(TimestreamQueryAsyncClient client, QueryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private QueryPublisher(TimestreamQueryAsyncClient client, QueryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new QueryResponseFetcher();
    }

    public void subscribe(Subscriber<? super QueryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Row> rows() {
        return this.flatMapIterable(response -> response.rows());
    }

    private class QueryResponseFetcher
    implements AsyncPageFetcher<QueryResponse> {
        private QueryResponseFetcher() {
        }

        public boolean hasNextPage(QueryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<QueryResponse> nextPage(QueryResponse previousPage) {
            if (previousPage == null) {
                return QueryPublisher.this.client.query(QueryPublisher.this.firstRequest);
            }
            return QueryPublisher.this.client.query((QueryRequest)((Object)QueryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

