/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.timestreamquery.model.DimensionMapping;
import software.amazon.awssdk.services.timestreamquery.model.DimensionMappingListCopier;
import software.amazon.awssdk.services.timestreamquery.model.MixedMeasureMapping;
import software.amazon.awssdk.services.timestreamquery.model.MixedMeasureMappingListCopier;
import software.amazon.awssdk.services.timestreamquery.model.MultiMeasureMappings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimestreamConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimestreamConfiguration> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(TimestreamConfiguration.getter(TimestreamConfiguration::databaseName)).setter(TimestreamConfiguration.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(TimestreamConfiguration.getter(TimestreamConfiguration::tableName)).setter(TimestreamConfiguration.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> TIME_COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeColumn").getter(TimestreamConfiguration.getter(TimestreamConfiguration::timeColumn)).setter(TimestreamConfiguration.setter(Builder::timeColumn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeColumn").build()}).build();
    private static final SdkField<List<DimensionMapping>> DIMENSION_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DimensionMappings").getter(TimestreamConfiguration.getter(TimestreamConfiguration::dimensionMappings)).setter(TimestreamConfiguration.setter(Builder::dimensionMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DimensionMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MultiMeasureMappings> MULTI_MEASURE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MultiMeasureMappings").getter(TimestreamConfiguration.getter(TimestreamConfiguration::multiMeasureMappings)).setter(TimestreamConfiguration.setter(Builder::multiMeasureMappings)).constructor(MultiMeasureMappings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiMeasureMappings").build()}).build();
    private static final SdkField<List<MixedMeasureMapping>> MIXED_MEASURE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MixedMeasureMappings").getter(TimestreamConfiguration.getter(TimestreamConfiguration::mixedMeasureMappings)).setter(TimestreamConfiguration.setter(Builder::mixedMeasureMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MixedMeasureMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MixedMeasureMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MEASURE_NAME_COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeasureNameColumn").getter(TimestreamConfiguration.getter(TimestreamConfiguration::measureNameColumn)).setter(TimestreamConfiguration.setter(Builder::measureNameColumn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureNameColumn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD, TABLE_NAME_FIELD, TIME_COLUMN_FIELD, DIMENSION_MAPPINGS_FIELD, MULTI_MEASURE_MAPPINGS_FIELD, MIXED_MEASURE_MAPPINGS_FIELD, MEASURE_NAME_COLUMN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TimestreamConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final String tableName;
    private final String timeColumn;
    private final List<DimensionMapping> dimensionMappings;
    private final MultiMeasureMappings multiMeasureMappings;
    private final List<MixedMeasureMapping> mixedMeasureMappings;
    private final String measureNameColumn;

    private TimestreamConfiguration(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.timeColumn = builder.timeColumn;
        this.dimensionMappings = builder.dimensionMappings;
        this.multiMeasureMappings = builder.multiMeasureMappings;
        this.mixedMeasureMappings = builder.mixedMeasureMappings;
        this.measureNameColumn = builder.measureNameColumn;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String timeColumn() {
        return this.timeColumn;
    }

    public final boolean hasDimensionMappings() {
        return this.dimensionMappings != null && !(this.dimensionMappings instanceof SdkAutoConstructList);
    }

    public final List<DimensionMapping> dimensionMappings() {
        return this.dimensionMappings;
    }

    public final MultiMeasureMappings multiMeasureMappings() {
        return this.multiMeasureMappings;
    }

    public final boolean hasMixedMeasureMappings() {
        return this.mixedMeasureMappings != null && !(this.mixedMeasureMappings instanceof SdkAutoConstructList);
    }

    public final List<MixedMeasureMapping> mixedMeasureMappings() {
        return this.mixedMeasureMappings;
    }

    public final String measureNameColumn() {
        return this.measureNameColumn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeColumn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensionMappings() ? this.dimensionMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.multiMeasureMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMixedMeasureMappings() ? this.mixedMeasureMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.measureNameColumn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimestreamConfiguration)) {
            return false;
        }
        TimestreamConfiguration other = (TimestreamConfiguration)obj;
        return Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.timeColumn(), other.timeColumn()) && this.hasDimensionMappings() == other.hasDimensionMappings() && Objects.equals(this.dimensionMappings(), other.dimensionMappings()) && Objects.equals(this.multiMeasureMappings(), other.multiMeasureMappings()) && this.hasMixedMeasureMappings() == other.hasMixedMeasureMappings() && Objects.equals(this.mixedMeasureMappings(), other.mixedMeasureMappings()) && Objects.equals(this.measureNameColumn(), other.measureNameColumn());
    }

    public final String toString() {
        return ToString.builder((String)"TimestreamConfiguration").add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("TimeColumn", (Object)this.timeColumn()).add("DimensionMappings", this.hasDimensionMappings() ? this.dimensionMappings() : null).add("MultiMeasureMappings", (Object)this.multiMeasureMappings()).add("MixedMeasureMappings", this.hasMixedMeasureMappings() ? this.mixedMeasureMappings() : null).add("MeasureNameColumn", (Object)this.measureNameColumn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "TimeColumn": {
                return Optional.ofNullable(clazz.cast(this.timeColumn()));
            }
            case "DimensionMappings": {
                return Optional.ofNullable(clazz.cast(this.dimensionMappings()));
            }
            case "MultiMeasureMappings": {
                return Optional.ofNullable(clazz.cast(this.multiMeasureMappings()));
            }
            case "MixedMeasureMappings": {
                return Optional.ofNullable(clazz.cast(this.mixedMeasureMappings()));
            }
            case "MeasureNameColumn": {
                return Optional.ofNullable(clazz.cast(this.measureNameColumn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("TimeColumn", TIME_COLUMN_FIELD);
        map.put("DimensionMappings", DIMENSION_MAPPINGS_FIELD);
        map.put("MultiMeasureMappings", MULTI_MEASURE_MAPPINGS_FIELD);
        map.put("MixedMeasureMappings", MIXED_MEASURE_MAPPINGS_FIELD);
        map.put("MeasureNameColumn", MEASURE_NAME_COLUMN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimestreamConfiguration, T> g) {
        return obj -> g.apply((TimestreamConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseName;
        private String tableName;
        private String timeColumn;
        private List<DimensionMapping> dimensionMappings = DefaultSdkAutoConstructList.getInstance();
        private MultiMeasureMappings multiMeasureMappings;
        private List<MixedMeasureMapping> mixedMeasureMappings = DefaultSdkAutoConstructList.getInstance();
        private String measureNameColumn;

        private BuilderImpl() {
        }

        private BuilderImpl(TimestreamConfiguration model) {
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.timeColumn(model.timeColumn);
            this.dimensionMappings(model.dimensionMappings);
            this.multiMeasureMappings(model.multiMeasureMappings);
            this.mixedMeasureMappings(model.mixedMeasureMappings);
            this.measureNameColumn(model.measureNameColumn);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getTimeColumn() {
            return this.timeColumn;
        }

        public final void setTimeColumn(String timeColumn) {
            this.timeColumn = timeColumn;
        }

        @Override
        public final Builder timeColumn(String timeColumn) {
            this.timeColumn = timeColumn;
            return this;
        }

        public final List<DimensionMapping.Builder> getDimensionMappings() {
            List<DimensionMapping.Builder> result = DimensionMappingListCopier.copyToBuilder(this.dimensionMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensionMappings(Collection<DimensionMapping.BuilderImpl> dimensionMappings) {
            this.dimensionMappings = DimensionMappingListCopier.copyFromBuilder(dimensionMappings);
        }

        @Override
        public final Builder dimensionMappings(Collection<DimensionMapping> dimensionMappings) {
            this.dimensionMappings = DimensionMappingListCopier.copy(dimensionMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionMappings(DimensionMapping ... dimensionMappings) {
            this.dimensionMappings(Arrays.asList(dimensionMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionMappings(Consumer<DimensionMapping.Builder> ... dimensionMappings) {
            this.dimensionMappings(Stream.of(dimensionMappings).map(c -> (DimensionMapping)((DimensionMapping.Builder)DimensionMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MultiMeasureMappings.Builder getMultiMeasureMappings() {
            return this.multiMeasureMappings != null ? this.multiMeasureMappings.toBuilder() : null;
        }

        public final void setMultiMeasureMappings(MultiMeasureMappings.BuilderImpl multiMeasureMappings) {
            this.multiMeasureMappings = multiMeasureMappings != null ? multiMeasureMappings.build() : null;
        }

        @Override
        public final Builder multiMeasureMappings(MultiMeasureMappings multiMeasureMappings) {
            this.multiMeasureMappings = multiMeasureMappings;
            return this;
        }

        public final List<MixedMeasureMapping.Builder> getMixedMeasureMappings() {
            List<MixedMeasureMapping.Builder> result = MixedMeasureMappingListCopier.copyToBuilder(this.mixedMeasureMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMixedMeasureMappings(Collection<MixedMeasureMapping.BuilderImpl> mixedMeasureMappings) {
            this.mixedMeasureMappings = MixedMeasureMappingListCopier.copyFromBuilder(mixedMeasureMappings);
        }

        @Override
        public final Builder mixedMeasureMappings(Collection<MixedMeasureMapping> mixedMeasureMappings) {
            this.mixedMeasureMappings = MixedMeasureMappingListCopier.copy(mixedMeasureMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mixedMeasureMappings(MixedMeasureMapping ... mixedMeasureMappings) {
            this.mixedMeasureMappings(Arrays.asList(mixedMeasureMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mixedMeasureMappings(Consumer<MixedMeasureMapping.Builder> ... mixedMeasureMappings) {
            this.mixedMeasureMappings(Stream.of(mixedMeasureMappings).map(c -> (MixedMeasureMapping)((MixedMeasureMapping.Builder)MixedMeasureMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMeasureNameColumn() {
            return this.measureNameColumn;
        }

        public final void setMeasureNameColumn(String measureNameColumn) {
            this.measureNameColumn = measureNameColumn;
        }

        @Override
        public final Builder measureNameColumn(String measureNameColumn) {
            this.measureNameColumn = measureNameColumn;
            return this;
        }

        public TimestreamConfiguration build() {
            return new TimestreamConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimestreamConfiguration> {
        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder timeColumn(String var1);

        public Builder dimensionMappings(Collection<DimensionMapping> var1);

        public Builder dimensionMappings(DimensionMapping ... var1);

        public Builder dimensionMappings(Consumer<DimensionMapping.Builder> ... var1);

        public Builder multiMeasureMappings(MultiMeasureMappings var1);

        default public Builder multiMeasureMappings(Consumer<MultiMeasureMappings.Builder> multiMeasureMappings) {
            return this.multiMeasureMappings((MultiMeasureMappings)((MultiMeasureMappings.Builder)MultiMeasureMappings.builder().applyMutation(multiMeasureMappings)).build());
        }

        public Builder mixedMeasureMappings(Collection<MixedMeasureMapping> var1);

        public Builder mixedMeasureMappings(MixedMeasureMapping ... var1);

        public Builder mixedMeasureMappings(Consumer<MixedMeasureMapping.Builder> ... var1);

        public Builder measureNameColumn(String var1);
    }
}

