/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ComputeMode {
    ON_DEMAND("ON_DEMAND"),
    PROVISIONED("PROVISIONED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ComputeMode> VALUE_MAP;
    private final String value;

    private ComputeMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComputeMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComputeMode> knownValues() {
        EnumSet<ComputeMode> knownValues = EnumSet.allOf(ComputeMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ComputeMode.class, ComputeMode::toString);
    }
}

