/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScalarMeasureValueType {
    BIGINT("BIGINT"),
    BOOLEAN("BOOLEAN"),
    DOUBLE("DOUBLE"),
    VARCHAR("VARCHAR"),
    TIMESTAMP("TIMESTAMP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScalarMeasureValueType> VALUE_MAP;
    private final String value;

    private ScalarMeasureValueType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScalarMeasureValueType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScalarMeasureValueType> knownValues() {
        EnumSet<ScalarMeasureValueType> knownValues = EnumSet.allOf(ScalarMeasureValueType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScalarMeasureValueType.class, ScalarMeasureValueType::toString);
    }
}

