/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryInsights;
import software.amazon.awssdk.services.timestreamquery.model.TimestreamQueryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteScheduledQueryRequest
extends TimestreamQueryRequest
implements ToCopyableBuilder<Builder, ExecuteScheduledQueryRequest> {
    private static final SdkField<String> SCHEDULED_QUERY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduledQueryArn").getter(ExecuteScheduledQueryRequest.getter(ExecuteScheduledQueryRequest::scheduledQueryArn)).setter(ExecuteScheduledQueryRequest.setter(Builder::scheduledQueryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledQueryArn").build()}).build();
    private static final SdkField<Instant> INVOCATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InvocationTime").getter(ExecuteScheduledQueryRequest.getter(ExecuteScheduledQueryRequest::invocationTime)).setter(ExecuteScheduledQueryRequest.setter(Builder::invocationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationTime").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ExecuteScheduledQueryRequest.getter(ExecuteScheduledQueryRequest::clientToken)).setter(ExecuteScheduledQueryRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<ScheduledQueryInsights> QUERY_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryInsights").getter(ExecuteScheduledQueryRequest.getter(ExecuteScheduledQueryRequest::queryInsights)).setter(ExecuteScheduledQueryRequest.setter(Builder::queryInsights)).constructor(ScheduledQueryInsights::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryInsights").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_QUERY_ARN_FIELD, INVOCATION_TIME_FIELD, CLIENT_TOKEN_FIELD, QUERY_INSIGHTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecuteScheduledQueryRequest.memberNameToFieldInitializer();
    private final String scheduledQueryArn;
    private final Instant invocationTime;
    private final String clientToken;
    private final ScheduledQueryInsights queryInsights;

    private ExecuteScheduledQueryRequest(BuilderImpl builder) {
        super(builder);
        this.scheduledQueryArn = builder.scheduledQueryArn;
        this.invocationTime = builder.invocationTime;
        this.clientToken = builder.clientToken;
        this.queryInsights = builder.queryInsights;
    }

    public final String scheduledQueryArn() {
        return this.scheduledQueryArn;
    }

    public final Instant invocationTime() {
        return this.invocationTime;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final ScheduledQueryInsights queryInsights() {
        return this.queryInsights;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledQueryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryInsights());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteScheduledQueryRequest)) {
            return false;
        }
        ExecuteScheduledQueryRequest other = (ExecuteScheduledQueryRequest)((Object)obj);
        return Objects.equals(this.scheduledQueryArn(), other.scheduledQueryArn()) && Objects.equals(this.invocationTime(), other.invocationTime()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.queryInsights(), other.queryInsights());
    }

    public final String toString() {
        return ToString.builder((String)"ExecuteScheduledQueryRequest").add("ScheduledQueryArn", (Object)this.scheduledQueryArn()).add("InvocationTime", (Object)this.invocationTime()).add("ClientToken", (Object)(this.clientToken() == null ? null : "*** Sensitive Data Redacted ***")).add("QueryInsights", (Object)this.queryInsights()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduledQueryArn": {
                return Optional.ofNullable(clazz.cast(this.scheduledQueryArn()));
            }
            case "InvocationTime": {
                return Optional.ofNullable(clazz.cast(this.invocationTime()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "QueryInsights": {
                return Optional.ofNullable(clazz.cast(this.queryInsights()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ScheduledQueryArn", SCHEDULED_QUERY_ARN_FIELD);
        map.put("InvocationTime", INVOCATION_TIME_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("QueryInsights", QUERY_INSIGHTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecuteScheduledQueryRequest, T> g) {
        return obj -> g.apply((ExecuteScheduledQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamQueryRequest.BuilderImpl
    implements Builder {
        private String scheduledQueryArn;
        private Instant invocationTime;
        private String clientToken;
        private ScheduledQueryInsights queryInsights;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteScheduledQueryRequest model) {
            super(model);
            this.scheduledQueryArn(model.scheduledQueryArn);
            this.invocationTime(model.invocationTime);
            this.clientToken(model.clientToken);
            this.queryInsights(model.queryInsights);
        }

        public final String getScheduledQueryArn() {
            return this.scheduledQueryArn;
        }

        public final void setScheduledQueryArn(String scheduledQueryArn) {
            this.scheduledQueryArn = scheduledQueryArn;
        }

        @Override
        public final Builder scheduledQueryArn(String scheduledQueryArn) {
            this.scheduledQueryArn = scheduledQueryArn;
            return this;
        }

        public final Instant getInvocationTime() {
            return this.invocationTime;
        }

        public final void setInvocationTime(Instant invocationTime) {
            this.invocationTime = invocationTime;
        }

        @Override
        public final Builder invocationTime(Instant invocationTime) {
            this.invocationTime = invocationTime;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ScheduledQueryInsights.Builder getQueryInsights() {
            return this.queryInsights != null ? this.queryInsights.toBuilder() : null;
        }

        public final void setQueryInsights(ScheduledQueryInsights.BuilderImpl queryInsights) {
            this.queryInsights = queryInsights != null ? queryInsights.build() : null;
        }

        @Override
        public final Builder queryInsights(ScheduledQueryInsights queryInsights) {
            this.queryInsights = queryInsights;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteScheduledQueryRequest build() {
            return new ExecuteScheduledQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TimestreamQueryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecuteScheduledQueryRequest> {
        public Builder scheduledQueryArn(String var1);

        public Builder invocationTime(Instant var1);

        public Builder clientToken(String var1);

        public Builder queryInsights(ScheduledQueryInsights var1);

        default public Builder queryInsights(Consumer<ScheduledQueryInsights.Builder> queryInsights) {
            return this.queryInsights((ScheduledQueryInsights)((ScheduledQueryInsights.Builder)ScheduledQueryInsights.builder().applyMutation(queryInsights)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

