/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.timestreamquery.model.ColumnInfo;
import software.amazon.awssdk.services.timestreamquery.model.ColumnInfoListCopier;
import software.amazon.awssdk.services.timestreamquery.model.QueryInsightsResponse;
import software.amazon.awssdk.services.timestreamquery.model.QueryStatus;
import software.amazon.awssdk.services.timestreamquery.model.Row;
import software.amazon.awssdk.services.timestreamquery.model.RowListCopier;
import software.amazon.awssdk.services.timestreamquery.model.TimestreamQueryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryResponse
extends TimestreamQueryResponse
implements ToCopyableBuilder<Builder, QueryResponse> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryId").getter(QueryResponse.getter(QueryResponse::queryId)).setter(QueryResponse.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(QueryResponse.getter(QueryResponse::nextToken)).setter(QueryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<Row>> ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rows").getter(QueryResponse.getter(QueryResponse::rows)).setter(QueryResponse.setter(Builder::rows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Row::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ColumnInfo>> COLUMN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnInfo").getter(QueryResponse.getter(QueryResponse::columnInfo)).setter(QueryResponse.setter(Builder::columnInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<QueryStatus> QUERY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryStatus").getter(QueryResponse.getter(QueryResponse::queryStatus)).setter(QueryResponse.setter(Builder::queryStatus)).constructor(QueryStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatus").build()}).build();
    private static final SdkField<QueryInsightsResponse> QUERY_INSIGHTS_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryInsightsResponse").getter(QueryResponse.getter(QueryResponse::queryInsightsResponse)).setter(QueryResponse.setter(Builder::queryInsightsResponse)).constructor(QueryInsightsResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryInsightsResponse").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD, NEXT_TOKEN_FIELD, ROWS_FIELD, COLUMN_INFO_FIELD, QUERY_STATUS_FIELD, QUERY_INSIGHTS_RESPONSE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QueryResponse.memberNameToFieldInitializer();
    private final String queryId;
    private final String nextToken;
    private final List<Row> rows;
    private final List<ColumnInfo> columnInfo;
    private final QueryStatus queryStatus;
    private final QueryInsightsResponse queryInsightsResponse;

    private QueryResponse(BuilderImpl builder) {
        super(builder);
        this.queryId = builder.queryId;
        this.nextToken = builder.nextToken;
        this.rows = builder.rows;
        this.columnInfo = builder.columnInfo;
        this.queryStatus = builder.queryStatus;
        this.queryInsightsResponse = builder.queryInsightsResponse;
    }

    public final String queryId() {
        return this.queryId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRows() {
        return this.rows != null && !(this.rows instanceof SdkAutoConstructList);
    }

    public final List<Row> rows() {
        return this.rows;
    }

    public final boolean hasColumnInfo() {
        return this.columnInfo != null && !(this.columnInfo instanceof SdkAutoConstructList);
    }

    public final List<ColumnInfo> columnInfo() {
        return this.columnInfo;
    }

    public final QueryStatus queryStatus() {
        return this.queryStatus;
    }

    public final QueryInsightsResponse queryInsightsResponse() {
        return this.queryInsightsResponse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRows() ? this.rows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnInfo() ? this.columnInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryInsightsResponse());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryResponse)) {
            return false;
        }
        QueryResponse other = (QueryResponse)((Object)obj);
        return Objects.equals(this.queryId(), other.queryId()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasRows() == other.hasRows() && Objects.equals(this.rows(), other.rows()) && this.hasColumnInfo() == other.hasColumnInfo() && Objects.equals(this.columnInfo(), other.columnInfo()) && Objects.equals(this.queryStatus(), other.queryStatus()) && Objects.equals(this.queryInsightsResponse(), other.queryInsightsResponse());
    }

    public final String toString() {
        return ToString.builder((String)"QueryResponse").add("QueryId", (Object)this.queryId()).add("NextToken", (Object)this.nextToken()).add("Rows", this.hasRows() ? this.rows() : null).add("ColumnInfo", this.hasColumnInfo() ? this.columnInfo() : null).add("QueryStatus", (Object)this.queryStatus()).add("QueryInsightsResponse", (Object)this.queryInsightsResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Rows": {
                return Optional.ofNullable(clazz.cast(this.rows()));
            }
            case "ColumnInfo": {
                return Optional.ofNullable(clazz.cast(this.columnInfo()));
            }
            case "QueryStatus": {
                return Optional.ofNullable(clazz.cast(this.queryStatus()));
            }
            case "QueryInsightsResponse": {
                return Optional.ofNullable(clazz.cast(this.queryInsightsResponse()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("QueryId", QUERY_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Rows", ROWS_FIELD);
        map.put("ColumnInfo", COLUMN_INFO_FIELD);
        map.put("QueryStatus", QUERY_STATUS_FIELD);
        map.put("QueryInsightsResponse", QUERY_INSIGHTS_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryResponse, T> g) {
        return obj -> g.apply((QueryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamQueryResponse.BuilderImpl
    implements Builder {
        private String queryId;
        private String nextToken;
        private List<Row> rows = DefaultSdkAutoConstructList.getInstance();
        private List<ColumnInfo> columnInfo = DefaultSdkAutoConstructList.getInstance();
        private QueryStatus queryStatus;
        private QueryInsightsResponse queryInsightsResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryResponse model) {
            super(model);
            this.queryId(model.queryId);
            this.nextToken(model.nextToken);
            this.rows(model.rows);
            this.columnInfo(model.columnInfo);
            this.queryStatus(model.queryStatus);
            this.queryInsightsResponse(model.queryInsightsResponse);
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Row.Builder> getRows() {
            List<Row.Builder> result = RowListCopier.copyToBuilder(this.rows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRows(Collection<Row.BuilderImpl> rows) {
            this.rows = RowListCopier.copyFromBuilder(rows);
        }

        @Override
        public final Builder rows(Collection<Row> rows) {
            this.rows = RowListCopier.copy(rows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Row ... rows) {
            this.rows(Arrays.asList(rows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Consumer<Row.Builder> ... rows) {
            this.rows(Stream.of(rows).map(c -> (Row)((Row.Builder)Row.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ColumnInfo.Builder> getColumnInfo() {
            List<ColumnInfo.Builder> result = ColumnInfoListCopier.copyToBuilder(this.columnInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnInfo(Collection<ColumnInfo.BuilderImpl> columnInfo) {
            this.columnInfo = ColumnInfoListCopier.copyFromBuilder(columnInfo);
        }

        @Override
        public final Builder columnInfo(Collection<ColumnInfo> columnInfo) {
            this.columnInfo = ColumnInfoListCopier.copy(columnInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnInfo(ColumnInfo ... columnInfo) {
            this.columnInfo(Arrays.asList(columnInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnInfo(Consumer<ColumnInfo.Builder> ... columnInfo) {
            this.columnInfo(Stream.of(columnInfo).map(c -> (ColumnInfo)((ColumnInfo.Builder)ColumnInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final QueryStatus.Builder getQueryStatus() {
            return this.queryStatus != null ? this.queryStatus.toBuilder() : null;
        }

        public final void setQueryStatus(QueryStatus.BuilderImpl queryStatus) {
            this.queryStatus = queryStatus != null ? queryStatus.build() : null;
        }

        @Override
        public final Builder queryStatus(QueryStatus queryStatus) {
            this.queryStatus = queryStatus;
            return this;
        }

        public final QueryInsightsResponse.Builder getQueryInsightsResponse() {
            return this.queryInsightsResponse != null ? this.queryInsightsResponse.toBuilder() : null;
        }

        public final void setQueryInsightsResponse(QueryInsightsResponse.BuilderImpl queryInsightsResponse) {
            this.queryInsightsResponse = queryInsightsResponse != null ? queryInsightsResponse.build() : null;
        }

        @Override
        public final Builder queryInsightsResponse(QueryInsightsResponse queryInsightsResponse) {
            this.queryInsightsResponse = queryInsightsResponse;
            return this;
        }

        @Override
        public QueryResponse build() {
            return new QueryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TimestreamQueryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, QueryResponse> {
        public Builder queryId(String var1);

        public Builder nextToken(String var1);

        public Builder rows(Collection<Row> var1);

        public Builder rows(Row ... var1);

        public Builder rows(Consumer<Row.Builder> ... var1);

        public Builder columnInfo(Collection<ColumnInfo> var1);

        public Builder columnInfo(ColumnInfo ... var1);

        public Builder columnInfo(Consumer<ColumnInfo.Builder> ... var1);

        public Builder queryStatus(QueryStatus var1);

        default public Builder queryStatus(Consumer<QueryStatus.Builder> queryStatus) {
            return this.queryStatus((QueryStatus)((QueryStatus.Builder)QueryStatus.builder().applyMutation(queryStatus)).build());
        }

        public Builder queryInsightsResponse(QueryInsightsResponse var1);

        default public Builder queryInsightsResponse(Consumer<QueryInsightsResponse.Builder> queryInsightsResponse) {
            return this.queryInsightsResponse((QueryInsightsResponse)((QueryInsightsResponse.Builder)QueryInsightsResponse.builder().applyMutation(queryInsightsResponse)).build());
        }
    }
}

