/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreamquery.model.SnsConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountSettingsNotificationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountSettingsNotificationConfiguration> {
    private static final SdkField<SnsConfiguration> SNS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnsConfiguration").getter(AccountSettingsNotificationConfiguration.getter(AccountSettingsNotificationConfiguration::snsConfiguration)).setter(AccountSettingsNotificationConfiguration.setter(Builder::snsConfiguration)).constructor(SnsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsConfiguration").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(AccountSettingsNotificationConfiguration.getter(AccountSettingsNotificationConfiguration::roleArn)).setter(AccountSettingsNotificationConfiguration.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_CONFIGURATION_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SnsConfiguration", SNS_CONFIGURATION_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final SnsConfiguration snsConfiguration;
    private final String roleArn;

    private AccountSettingsNotificationConfiguration(BuilderImpl builder) {
        this.snsConfiguration = builder.snsConfiguration;
        this.roleArn = builder.roleArn;
    }

    public final SnsConfiguration snsConfiguration() {
        return this.snsConfiguration;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSettingsNotificationConfiguration)) {
            return false;
        }
        AccountSettingsNotificationConfiguration other = (AccountSettingsNotificationConfiguration)obj;
        return Objects.equals(this.snsConfiguration(), other.snsConfiguration()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"AccountSettingsNotificationConfiguration").add("SnsConfiguration", (Object)this.snsConfiguration()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.snsConfiguration()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AccountSettingsNotificationConfiguration, T> g) {
        return obj -> g.apply((AccountSettingsNotificationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SnsConfiguration snsConfiguration;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSettingsNotificationConfiguration model) {
            this.snsConfiguration(model.snsConfiguration);
            this.roleArn(model.roleArn);
        }

        public final SnsConfiguration.Builder getSnsConfiguration() {
            return this.snsConfiguration != null ? this.snsConfiguration.toBuilder() : null;
        }

        public final void setSnsConfiguration(SnsConfiguration.BuilderImpl snsConfiguration) {
            this.snsConfiguration = snsConfiguration != null ? snsConfiguration.build() : null;
        }

        @Override
        public final Builder snsConfiguration(SnsConfiguration snsConfiguration) {
            this.snsConfiguration = snsConfiguration;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public AccountSettingsNotificationConfiguration build() {
            return new AccountSettingsNotificationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountSettingsNotificationConfiguration> {
        public Builder snsConfiguration(SnsConfiguration var1);

        default public Builder snsConfiguration(Consumer<SnsConfiguration.Builder> snsConfiguration) {
            return this.snsConfiguration((SnsConfiguration)((SnsConfiguration.Builder)SnsConfiguration.builder().applyMutation(snsConfiguration)).build());
        }

        public Builder roleArn(String var1);
    }
}

