/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.timestreamquery.DefaultTimestreamQueryClientBuilder;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryClientBuilder;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryServiceClientConfiguration;
import software.amazon.awssdk.services.timestreamquery.model.AccessDeniedException;
import software.amazon.awssdk.services.timestreamquery.model.CancelQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.CancelQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.ConflictException;
import software.amazon.awssdk.services.timestreamquery.model.CreateScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.CreateScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.DeleteScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.DeleteScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.timestreamquery.model.DescribeScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.DescribeScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.ExecuteScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.ExecuteScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.InternalServerException;
import software.amazon.awssdk.services.timestreamquery.model.InvalidEndpointException;
import software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesRequest;
import software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesResponse;
import software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.timestreamquery.model.PrepareQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.PrepareQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.QueryExecutionException;
import software.amazon.awssdk.services.timestreamquery.model.QueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.QueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.ResourceNotFoundException;
import software.amazon.awssdk.services.timestreamquery.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.timestreamquery.model.TagResourceRequest;
import software.amazon.awssdk.services.timestreamquery.model.TagResourceResponse;
import software.amazon.awssdk.services.timestreamquery.model.ThrottlingException;
import software.amazon.awssdk.services.timestreamquery.model.TimestreamQueryException;
import software.amazon.awssdk.services.timestreamquery.model.UntagResourceRequest;
import software.amazon.awssdk.services.timestreamquery.model.UntagResourceResponse;
import software.amazon.awssdk.services.timestreamquery.model.UpdateScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.UpdateScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.ValidationException;
import software.amazon.awssdk.services.timestreamquery.paginators.ListScheduledQueriesIterable;
import software.amazon.awssdk.services.timestreamquery.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.timestreamquery.paginators.QueryIterable;

@SdkPublicApi
@ThreadSafe
public interface TimestreamQueryClient
extends AwsClient {
    public static final String SERVICE_NAME = "timestream";
    public static final String SERVICE_METADATA_ID = "query.timestream";

    default public CancelQueryResponse cancelQuery(CancelQueryRequest cancelQueryRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        throw new UnsupportedOperationException();
    }

    default public CancelQueryResponse cancelQuery(Consumer<CancelQueryRequest.Builder> cancelQueryRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return this.cancelQuery((CancelQueryRequest)((Object)((CancelQueryRequest.Builder)CancelQueryRequest.builder().applyMutation(cancelQueryRequest)).build()));
    }

    default public CreateScheduledQueryResponse createScheduledQuery(CreateScheduledQueryRequest createScheduledQueryRequest) throws AccessDeniedException, ConflictException, InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        throw new UnsupportedOperationException();
    }

    default public CreateScheduledQueryResponse createScheduledQuery(Consumer<CreateScheduledQueryRequest.Builder> createScheduledQueryRequest) throws AccessDeniedException, ConflictException, InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return this.createScheduledQuery((CreateScheduledQueryRequest)((Object)((CreateScheduledQueryRequest.Builder)CreateScheduledQueryRequest.builder().applyMutation(createScheduledQueryRequest)).build()));
    }

    default public DeleteScheduledQueryResponse deleteScheduledQuery(DeleteScheduledQueryRequest deleteScheduledQueryRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        throw new UnsupportedOperationException();
    }

    default public DeleteScheduledQueryResponse deleteScheduledQuery(Consumer<DeleteScheduledQueryRequest.Builder> deleteScheduledQueryRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return this.deleteScheduledQuery((DeleteScheduledQueryRequest)((Object)((DeleteScheduledQueryRequest.Builder)DeleteScheduledQueryRequest.builder().applyMutation(deleteScheduledQueryRequest)).build()));
    }

    default public DescribeEndpointsResponse describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) throws InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, TimestreamQueryException {
        throw new UnsupportedOperationException();
    }

    default public DescribeEndpointsResponse describeEndpoints(Consumer<DescribeEndpointsRequest.Builder> describeEndpointsRequest) throws InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return this.describeEndpoints((DescribeEndpointsRequest)((Object)((DescribeEndpointsRequest.Builder)DescribeEndpointsRequest.builder().applyMutation(describeEndpointsRequest)).build()));
    }

    default public DescribeScheduledQueryResponse describeScheduledQuery(DescribeScheduledQueryRequest describeScheduledQueryRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        throw new UnsupportedOperationException();
    }

    default public DescribeScheduledQueryResponse describeScheduledQuery(Consumer<DescribeScheduledQueryRequest.Builder> describeScheduledQueryRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return this.describeScheduledQuery((DescribeScheduledQueryRequest)((Object)((DescribeScheduledQueryRequest.Builder)DescribeScheduledQueryRequest.builder().applyMutation(describeScheduledQueryRequest)).build()));
    }

    default public ExecuteScheduledQueryResponse executeScheduledQuery(ExecuteScheduledQueryRequest executeScheduledQueryRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        throw new UnsupportedOperationException();
    }

    default public ExecuteScheduledQueryResponse executeScheduledQuery(Consumer<ExecuteScheduledQueryRequest.Builder> executeScheduledQueryRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return this.executeScheduledQuery((ExecuteScheduledQueryRequest)((Object)((ExecuteScheduledQueryRequest.Builder)ExecuteScheduledQueryRequest.builder().applyMutation(executeScheduledQueryRequest)).build()));
    }

    default public ListScheduledQueriesResponse listScheduledQueries(ListScheduledQueriesRequest listScheduledQueriesRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        throw new UnsupportedOperationException();
    }

    default public ListScheduledQueriesResponse listScheduledQueries(Consumer<ListScheduledQueriesRequest.Builder> listScheduledQueriesRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return this.listScheduledQueries((ListScheduledQueriesRequest)((Object)((ListScheduledQueriesRequest.Builder)ListScheduledQueriesRequest.builder().applyMutation(listScheduledQueriesRequest)).build()));
    }

    default public ListScheduledQueriesIterable listScheduledQueriesPaginator(ListScheduledQueriesRequest listScheduledQueriesRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return new ListScheduledQueriesIterable(this, listScheduledQueriesRequest);
    }

    default public ListScheduledQueriesIterable listScheduledQueriesPaginator(Consumer<ListScheduledQueriesRequest.Builder> listScheduledQueriesRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return this.listScheduledQueriesPaginator((ListScheduledQueriesRequest)((Object)((ListScheduledQueriesRequest.Builder)ListScheduledQueriesRequest.builder().applyMutation(listScheduledQueriesRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return new ListTagsForResourceIterable(this, listTagsForResourceRequest);
    }

    default public ListTagsForResourceIterable listTagsForResourcePaginator(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return this.listTagsForResourcePaginator((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public PrepareQueryResponse prepareQuery(PrepareQueryRequest prepareQueryRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        throw new UnsupportedOperationException();
    }

    default public PrepareQueryResponse prepareQuery(Consumer<PrepareQueryRequest.Builder> prepareQueryRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return this.prepareQuery((PrepareQueryRequest)((Object)((PrepareQueryRequest.Builder)PrepareQueryRequest.builder().applyMutation(prepareQueryRequest)).build()));
    }

    default public QueryResponse query(QueryRequest queryRequest) throws AccessDeniedException, ConflictException, InternalServerException, QueryExecutionException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        throw new UnsupportedOperationException();
    }

    default public QueryResponse query(Consumer<QueryRequest.Builder> queryRequest) throws AccessDeniedException, ConflictException, InternalServerException, QueryExecutionException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return this.query((QueryRequest)((Object)((QueryRequest.Builder)QueryRequest.builder().applyMutation(queryRequest)).build()));
    }

    default public QueryIterable queryPaginator(QueryRequest queryRequest) throws AccessDeniedException, ConflictException, InternalServerException, QueryExecutionException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return new QueryIterable(this, queryRequest);
    }

    default public QueryIterable queryPaginator(Consumer<QueryRequest.Builder> queryRequest) throws AccessDeniedException, ConflictException, InternalServerException, QueryExecutionException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return this.queryPaginator((QueryRequest)((Object)((QueryRequest.Builder)QueryRequest.builder().applyMutation(queryRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ThrottlingException, ResourceNotFoundException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ValidationException, ThrottlingException, ResourceNotFoundException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateScheduledQueryResponse updateScheduledQuery(UpdateScheduledQueryRequest updateScheduledQueryRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        throw new UnsupportedOperationException();
    }

    default public UpdateScheduledQueryResponse updateScheduledQuery(Consumer<UpdateScheduledQueryRequest.Builder> updateScheduledQueryRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return this.updateScheduledQuery((UpdateScheduledQueryRequest)((Object)((UpdateScheduledQueryRequest.Builder)UpdateScheduledQueryRequest.builder().applyMutation(updateScheduledQueryRequest)).build()));
    }

    public static TimestreamQueryClient create() {
        return (TimestreamQueryClient)TimestreamQueryClient.builder().build();
    }

    public static TimestreamQueryClientBuilder builder() {
        return new DefaultTimestreamQueryClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_METADATA_ID);
    }

    default public TimestreamQueryServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

