/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DbInstanceType {
    DB_INFLUX_MEDIUM("db.influx.medium"),
    DB_INFLUX_LARGE("db.influx.large"),
    DB_INFLUX_XLARGE("db.influx.xlarge"),
    DB_INFLUX_2_XLARGE("db.influx.2xlarge"),
    DB_INFLUX_4_XLARGE("db.influx.4xlarge"),
    DB_INFLUX_8_XLARGE("db.influx.8xlarge"),
    DB_INFLUX_12_XLARGE("db.influx.12xlarge"),
    DB_INFLUX_16_XLARGE("db.influx.16xlarge"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DbInstanceType> VALUE_MAP;
    private final String value;

    private DbInstanceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DbInstanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DbInstanceType> knownValues() {
        EnumSet<DbInstanceType> knownValues = EnumSet.allOf(DbInstanceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DbInstanceType.class, DbInstanceType::toString);
    }
}

