/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.timestreaminfluxdb.TimestreamInfluxDbClient;
import software.amazon.awssdk.services.timestreaminfluxdb.internal.UserAgentUtils;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DbInstanceForClusterSummary;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesForClusterRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesForClusterResponse;

public class ListDbInstancesForClusterIterable
implements SdkIterable<ListDbInstancesForClusterResponse> {
    private final TimestreamInfluxDbClient client;
    private final ListDbInstancesForClusterRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDbInstancesForClusterIterable(TimestreamInfluxDbClient client, ListDbInstancesForClusterRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDbInstancesForClusterResponseFetcher();
    }

    public Iterator<ListDbInstancesForClusterResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DbInstanceForClusterSummary> items() {
        Function<ListDbInstancesForClusterResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDbInstancesForClusterResponseFetcher
    implements SyncPageFetcher<ListDbInstancesForClusterResponse> {
        private ListDbInstancesForClusterResponseFetcher() {
        }

        public boolean hasNextPage(ListDbInstancesForClusterResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDbInstancesForClusterResponse nextPage(ListDbInstancesForClusterResponse previousPage) {
            if (previousPage == null) {
                return ListDbInstancesForClusterIterable.this.client.listDbInstancesForCluster(ListDbInstancesForClusterIterable.this.firstRequest);
            }
            return ListDbInstancesForClusterIterable.this.client.listDbInstancesForCluster((ListDbInstancesForClusterRequest)((Object)ListDbInstancesForClusterIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

