/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.timestreaminfluxdb.TimestreamInfluxDbClient;
import software.amazon.awssdk.services.timestreaminfluxdb.internal.UserAgentUtils;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DbParameterGroupSummary;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbParameterGroupsRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbParameterGroupsResponse;

public class ListDbParameterGroupsIterable
implements SdkIterable<ListDbParameterGroupsResponse> {
    private final TimestreamInfluxDbClient client;
    private final ListDbParameterGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDbParameterGroupsIterable(TimestreamInfluxDbClient client, ListDbParameterGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDbParameterGroupsResponseFetcher();
    }

    public Iterator<ListDbParameterGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DbParameterGroupSummary> items() {
        Function<ListDbParameterGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDbParameterGroupsResponseFetcher
    implements SyncPageFetcher<ListDbParameterGroupsResponse> {
        private ListDbParameterGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListDbParameterGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDbParameterGroupsResponse nextPage(ListDbParameterGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListDbParameterGroupsIterable.this.client.listDbParameterGroups(ListDbParameterGroupsIterable.this.firstRequest);
            }
            return ListDbParameterGroupsIterable.this.client.listDbParameterGroups((ListDbParameterGroupsRequest)((Object)ListDbParameterGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

