/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.timestreaminfluxdb.TimestreamInfluxDbAsyncClient;
import software.amazon.awssdk.services.timestreaminfluxdb.internal.UserAgentUtils;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DbInstanceSummary;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesResponse;

public class ListDbInstancesPublisher
implements SdkPublisher<ListDbInstancesResponse> {
    private final TimestreamInfluxDbAsyncClient client;
    private final ListDbInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDbInstancesPublisher(TimestreamInfluxDbAsyncClient client, ListDbInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDbInstancesPublisher(TimestreamInfluxDbAsyncClient client, ListDbInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDbInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDbInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DbInstanceSummary> items() {
        Function<ListDbInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDbInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDbInstancesResponseFetcher
    implements AsyncPageFetcher<ListDbInstancesResponse> {
        private ListDbInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListDbInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDbInstancesResponse> nextPage(ListDbInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListDbInstancesPublisher.this.client.listDbInstances(ListDbInstancesPublisher.this.firstRequest);
            }
            return ListDbInstancesPublisher.this.client.listDbInstances((ListDbInstancesRequest)((Object)ListDbInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

