/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.ContentClassifier;
import software.amazon.awssdk.services.textract.model.ContentClassifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HumanLoopDataAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HumanLoopDataAttributes> {
    private static final SdkField<List<String>> CONTENT_CLASSIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContentClassifiers").getter(HumanLoopDataAttributes.getter(HumanLoopDataAttributes::contentClassifiersAsStrings)).setter(HumanLoopDataAttributes.setter(Builder::contentClassifiersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentClassifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_CLASSIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HumanLoopDataAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> contentClassifiers;

    private HumanLoopDataAttributes(BuilderImpl builder) {
        this.contentClassifiers = builder.contentClassifiers;
    }

    public final List<ContentClassifier> contentClassifiers() {
        return ContentClassifiersCopier.copyStringToEnum(this.contentClassifiers);
    }

    public final boolean hasContentClassifiers() {
        return this.contentClassifiers != null && !(this.contentClassifiers instanceof SdkAutoConstructList);
    }

    public final List<String> contentClassifiersAsStrings() {
        return this.contentClassifiers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContentClassifiers() ? this.contentClassifiersAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanLoopDataAttributes)) {
            return false;
        }
        HumanLoopDataAttributes other = (HumanLoopDataAttributes)obj;
        return this.hasContentClassifiers() == other.hasContentClassifiers() && Objects.equals(this.contentClassifiersAsStrings(), other.contentClassifiersAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"HumanLoopDataAttributes").add("ContentClassifiers", this.hasContentClassifiers() ? this.contentClassifiersAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContentClassifiers": {
                return Optional.ofNullable(clazz.cast(this.contentClassifiersAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("ContentClassifiers", CONTENT_CLASSIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HumanLoopDataAttributes, T> g) {
        return obj -> g.apply((HumanLoopDataAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> contentClassifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HumanLoopDataAttributes model) {
            this.contentClassifiersWithStrings(model.contentClassifiers);
        }

        public final Collection<String> getContentClassifiers() {
            if (this.contentClassifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contentClassifiers;
        }

        public final void setContentClassifiers(Collection<String> contentClassifiers) {
            this.contentClassifiers = ContentClassifiersCopier.copy(contentClassifiers);
        }

        @Override
        public final Builder contentClassifiersWithStrings(Collection<String> contentClassifiers) {
            this.contentClassifiers = ContentClassifiersCopier.copy(contentClassifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentClassifiersWithStrings(String ... contentClassifiers) {
            this.contentClassifiersWithStrings(Arrays.asList(contentClassifiers));
            return this;
        }

        @Override
        public final Builder contentClassifiers(Collection<ContentClassifier> contentClassifiers) {
            this.contentClassifiers = ContentClassifiersCopier.copyEnumToString(contentClassifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentClassifiers(ContentClassifier ... contentClassifiers) {
            this.contentClassifiers(Arrays.asList(contentClassifiers));
            return this;
        }

        public HumanLoopDataAttributes build() {
            return new HumanLoopDataAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HumanLoopDataAttributes> {
        public Builder contentClassifiersWithStrings(Collection<String> var1);

        public Builder contentClassifiersWithStrings(String ... var1);

        public Builder contentClassifiers(Collection<ContentClassifier> var1);

        public Builder contentClassifiers(ContentClassifier ... var1);
    }
}

