/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.textract.TextractClient;
import software.amazon.awssdk.services.textract.internal.UserAgentUtils;
import software.amazon.awssdk.services.textract.model.AdapterVersionOverview;
import software.amazon.awssdk.services.textract.model.ListAdapterVersionsRequest;
import software.amazon.awssdk.services.textract.model.ListAdapterVersionsResponse;

public class ListAdapterVersionsIterable
implements SdkIterable<ListAdapterVersionsResponse> {
    private final TextractClient client;
    private final ListAdapterVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAdapterVersionsIterable(TextractClient client, ListAdapterVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAdapterVersionsResponseFetcher();
    }

    public Iterator<ListAdapterVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AdapterVersionOverview> adapterVersions() {
        Function<ListAdapterVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.adapterVersions() != null) {
                return response.adapterVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAdapterVersionsResponseFetcher
    implements SyncPageFetcher<ListAdapterVersionsResponse> {
        private ListAdapterVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAdapterVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAdapterVersionsResponse nextPage(ListAdapterVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListAdapterVersionsIterable.this.client.listAdapterVersions(ListAdapterVersionsIterable.this.firstRequest);
            }
            return ListAdapterVersionsIterable.this.client.listAdapterVersions((ListAdapterVersionsRequest)((Object)ListAdapterVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

