/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Industries {
    CIRCULATING_ORG("CirculatingOrg"),
    PROFESSIONAL_ORG("ProfessionalOrg"),
    BANKS("Banks"),
    INSURANCE("Insurance"),
    PENSION_AND_BENEFIT_FUNDS("PensionAndBenefitFunds"),
    DEVELOPMENT_AGENCIES("DevelopmentAgencies"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Industries> VALUE_MAP;
    private final String value;

    private Industries(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Industries fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Industries> knownValues() {
        EnumSet<Industries> knownValues = EnumSet.allOf(Industries.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Industries.class, Industries::toString);
    }
}

