/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.taxsettings.model.IndonesiaTaxRegistrationNumberType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IndonesiaAdditionalInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IndonesiaAdditionalInfo> {
    private static final SdkField<String> DECISION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("decisionNumber").getter(IndonesiaAdditionalInfo.getter(IndonesiaAdditionalInfo::decisionNumber)).setter(IndonesiaAdditionalInfo.setter(Builder::decisionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionNumber").build()}).build();
    private static final SdkField<String> PPN_EXCEPTION_DESIGNATION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ppnExceptionDesignationCode").getter(IndonesiaAdditionalInfo.getter(IndonesiaAdditionalInfo::ppnExceptionDesignationCode)).setter(IndonesiaAdditionalInfo.setter(Builder::ppnExceptionDesignationCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ppnExceptionDesignationCode").build()}).build();
    private static final SdkField<String> TAX_REGISTRATION_NUMBER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taxRegistrationNumberType").getter(IndonesiaAdditionalInfo.getter(IndonesiaAdditionalInfo::taxRegistrationNumberTypeAsString)).setter(IndonesiaAdditionalInfo.setter(Builder::taxRegistrationNumberType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxRegistrationNumberType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECISION_NUMBER_FIELD, PPN_EXCEPTION_DESIGNATION_CODE_FIELD, TAX_REGISTRATION_NUMBER_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IndonesiaAdditionalInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String decisionNumber;
    private final String ppnExceptionDesignationCode;
    private final String taxRegistrationNumberType;

    private IndonesiaAdditionalInfo(BuilderImpl builder) {
        this.decisionNumber = builder.decisionNumber;
        this.ppnExceptionDesignationCode = builder.ppnExceptionDesignationCode;
        this.taxRegistrationNumberType = builder.taxRegistrationNumberType;
    }

    public final String decisionNumber() {
        return this.decisionNumber;
    }

    public final String ppnExceptionDesignationCode() {
        return this.ppnExceptionDesignationCode;
    }

    public final IndonesiaTaxRegistrationNumberType taxRegistrationNumberType() {
        return IndonesiaTaxRegistrationNumberType.fromValue(this.taxRegistrationNumberType);
    }

    public final String taxRegistrationNumberTypeAsString() {
        return this.taxRegistrationNumberType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.decisionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.ppnExceptionDesignationCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.taxRegistrationNumberTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndonesiaAdditionalInfo)) {
            return false;
        }
        IndonesiaAdditionalInfo other = (IndonesiaAdditionalInfo)obj;
        return Objects.equals(this.decisionNumber(), other.decisionNumber()) && Objects.equals(this.ppnExceptionDesignationCode(), other.ppnExceptionDesignationCode()) && Objects.equals(this.taxRegistrationNumberTypeAsString(), other.taxRegistrationNumberTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IndonesiaAdditionalInfo").add("DecisionNumber", (Object)this.decisionNumber()).add("PpnExceptionDesignationCode", (Object)this.ppnExceptionDesignationCode()).add("TaxRegistrationNumberType", (Object)this.taxRegistrationNumberTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "decisionNumber": {
                return Optional.ofNullable(clazz.cast(this.decisionNumber()));
            }
            case "ppnExceptionDesignationCode": {
                return Optional.ofNullable(clazz.cast(this.ppnExceptionDesignationCode()));
            }
            case "taxRegistrationNumberType": {
                return Optional.ofNullable(clazz.cast(this.taxRegistrationNumberTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("decisionNumber", DECISION_NUMBER_FIELD);
        map.put("ppnExceptionDesignationCode", PPN_EXCEPTION_DESIGNATION_CODE_FIELD);
        map.put("taxRegistrationNumberType", TAX_REGISTRATION_NUMBER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IndonesiaAdditionalInfo, T> g) {
        return obj -> g.apply((IndonesiaAdditionalInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String decisionNumber;
        private String ppnExceptionDesignationCode;
        private String taxRegistrationNumberType;

        private BuilderImpl() {
        }

        private BuilderImpl(IndonesiaAdditionalInfo model) {
            this.decisionNumber(model.decisionNumber);
            this.ppnExceptionDesignationCode(model.ppnExceptionDesignationCode);
            this.taxRegistrationNumberType(model.taxRegistrationNumberType);
        }

        public final String getDecisionNumber() {
            return this.decisionNumber;
        }

        public final void setDecisionNumber(String decisionNumber) {
            this.decisionNumber = decisionNumber;
        }

        @Override
        public final Builder decisionNumber(String decisionNumber) {
            this.decisionNumber = decisionNumber;
            return this;
        }

        public final String getPpnExceptionDesignationCode() {
            return this.ppnExceptionDesignationCode;
        }

        public final void setPpnExceptionDesignationCode(String ppnExceptionDesignationCode) {
            this.ppnExceptionDesignationCode = ppnExceptionDesignationCode;
        }

        @Override
        public final Builder ppnExceptionDesignationCode(String ppnExceptionDesignationCode) {
            this.ppnExceptionDesignationCode = ppnExceptionDesignationCode;
            return this;
        }

        public final String getTaxRegistrationNumberType() {
            return this.taxRegistrationNumberType;
        }

        public final void setTaxRegistrationNumberType(String taxRegistrationNumberType) {
            this.taxRegistrationNumberType = taxRegistrationNumberType;
        }

        @Override
        public final Builder taxRegistrationNumberType(String taxRegistrationNumberType) {
            this.taxRegistrationNumberType = taxRegistrationNumberType;
            return this;
        }

        @Override
        public final Builder taxRegistrationNumberType(IndonesiaTaxRegistrationNumberType taxRegistrationNumberType) {
            this.taxRegistrationNumberType(taxRegistrationNumberType == null ? null : taxRegistrationNumberType.toString());
            return this;
        }

        public IndonesiaAdditionalInfo build() {
            return new IndonesiaAdditionalInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IndonesiaAdditionalInfo> {
        public Builder decisionNumber(String var1);

        public Builder ppnExceptionDesignationCode(String var1);

        public Builder taxRegistrationNumberType(String var1);

        public Builder taxRegistrationNumberType(IndonesiaTaxRegistrationNumberType var1);
    }
}

