/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.taxsettings.model.BatchPutTaxRegistrationError;
import software.amazon.awssdk.services.taxsettings.model.BatchPutTaxRegistrationErrorsCopier;
import software.amazon.awssdk.services.taxsettings.model.TaxRegistrationStatus;
import software.amazon.awssdk.services.taxsettings.model.TaxSettingsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchPutTaxRegistrationResponse
extends TaxSettingsResponse
implements ToCopyableBuilder<Builder, BatchPutTaxRegistrationResponse> {
    private static final SdkField<List<BatchPutTaxRegistrationError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchPutTaxRegistrationResponse.getter(BatchPutTaxRegistrationResponse::errors)).setter(BatchPutTaxRegistrationResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchPutTaxRegistrationError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(BatchPutTaxRegistrationResponse.getter(BatchPutTaxRegistrationResponse::statusAsString)).setter(BatchPutTaxRegistrationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchPutTaxRegistrationResponse.memberNameToFieldInitializer();
    private final List<BatchPutTaxRegistrationError> errors;
    private final String status;

    private BatchPutTaxRegistrationResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.status = builder.status;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchPutTaxRegistrationError> errors() {
        return this.errors;
    }

    public final TaxRegistrationStatus status() {
        return TaxRegistrationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutTaxRegistrationResponse)) {
            return false;
        }
        BatchPutTaxRegistrationResponse other = (BatchPutTaxRegistrationResponse)((Object)obj);
        return this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BatchPutTaxRegistrationResponse").add("Errors", this.hasErrors() ? this.errors() : null).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errors", ERRORS_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchPutTaxRegistrationResponse, T> g) {
        return obj -> g.apply((BatchPutTaxRegistrationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TaxSettingsResponse.BuilderImpl
    implements Builder {
        private List<BatchPutTaxRegistrationError> errors = DefaultSdkAutoConstructList.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutTaxRegistrationResponse model) {
            super(model);
            this.errors(model.errors);
            this.status(model.status);
        }

        public final List<BatchPutTaxRegistrationError.Builder> getErrors() {
            List<BatchPutTaxRegistrationError.Builder> result = BatchPutTaxRegistrationErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchPutTaxRegistrationError.BuilderImpl> errors) {
            this.errors = BatchPutTaxRegistrationErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchPutTaxRegistrationError> errors) {
            this.errors = BatchPutTaxRegistrationErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchPutTaxRegistrationError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchPutTaxRegistrationError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchPutTaxRegistrationError)((BatchPutTaxRegistrationError.Builder)BatchPutTaxRegistrationError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaxRegistrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public BatchPutTaxRegistrationResponse build() {
            return new BatchPutTaxRegistrationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TaxSettingsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchPutTaxRegistrationResponse> {
        public Builder errors(Collection<BatchPutTaxRegistrationError> var1);

        public Builder errors(BatchPutTaxRegistrationError ... var1);

        public Builder errors(Consumer<BatchPutTaxRegistrationError.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(TaxRegistrationStatus var1);
    }
}

