/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.taxsettings.TaxSettingsAsyncClient;
import software.amazon.awssdk.services.taxsettings.internal.UserAgentUtils;
import software.amazon.awssdk.services.taxsettings.model.ListTaxExemptionsRequest;
import software.amazon.awssdk.services.taxsettings.model.ListTaxExemptionsResponse;
import software.amazon.awssdk.services.taxsettings.model.TaxExemptionDetails;

public class ListTaxExemptionsPublisher
implements SdkPublisher<ListTaxExemptionsResponse> {
    private final TaxSettingsAsyncClient client;
    private final ListTaxExemptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTaxExemptionsPublisher(TaxSettingsAsyncClient client, ListTaxExemptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTaxExemptionsPublisher(TaxSettingsAsyncClient client, ListTaxExemptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTaxExemptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTaxExemptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Map.Entry<String, TaxExemptionDetails>> taxExemptionDetailsMap() {
        Function<ListTaxExemptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.taxExemptionDetailsMap() != null) {
                return response.taxExemptionDetailsMap().entrySet().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTaxExemptionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTaxExemptionsResponseFetcher
    implements AsyncPageFetcher<ListTaxExemptionsResponse> {
        private ListTaxExemptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTaxExemptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTaxExemptionsResponse> nextPage(ListTaxExemptionsResponse previousPage) {
            if (previousPage == null) {
                return ListTaxExemptionsPublisher.this.client.listTaxExemptions(ListTaxExemptionsPublisher.this.firstRequest);
            }
            return ListTaxExemptionsPublisher.this.client.listTaxExemptions((ListTaxExemptionsRequest)((Object)ListTaxExemptionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

