/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RegistrationType {
    INTRA_EU("Intra-EU"),
    LOCAL("Local"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RegistrationType> VALUE_MAP;
    private final String value;

    private RegistrationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RegistrationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RegistrationType> knownValues() {
        EnumSet<RegistrationType> knownValues = EnumSet.allOf(RegistrationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RegistrationType.class, RegistrationType::toString);
    }
}

