/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.taxsettings.model.HeritageStatus;
import software.amazon.awssdk.services.taxsettings.model.TaxSettingsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutTaxInheritanceRequest
extends TaxSettingsRequest
implements ToCopyableBuilder<Builder, PutTaxInheritanceRequest> {
    private static final SdkField<String> HERITAGE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("heritageStatus").getter(PutTaxInheritanceRequest.getter(PutTaxInheritanceRequest::heritageStatusAsString)).setter(PutTaxInheritanceRequest.setter(Builder::heritageStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("heritageStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HERITAGE_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutTaxInheritanceRequest.memberNameToFieldInitializer();
    private final String heritageStatus;

    private PutTaxInheritanceRequest(BuilderImpl builder) {
        super(builder);
        this.heritageStatus = builder.heritageStatus;
    }

    public final HeritageStatus heritageStatus() {
        return HeritageStatus.fromValue(this.heritageStatus);
    }

    public final String heritageStatusAsString() {
        return this.heritageStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.heritageStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTaxInheritanceRequest)) {
            return false;
        }
        PutTaxInheritanceRequest other = (PutTaxInheritanceRequest)((Object)obj);
        return Objects.equals(this.heritageStatusAsString(), other.heritageStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutTaxInheritanceRequest").add("HeritageStatus", (Object)this.heritageStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "heritageStatus": {
                return Optional.ofNullable(clazz.cast(this.heritageStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("heritageStatus", HERITAGE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutTaxInheritanceRequest, T> g) {
        return obj -> g.apply((PutTaxInheritanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TaxSettingsRequest.BuilderImpl
    implements Builder {
        private String heritageStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PutTaxInheritanceRequest model) {
            super(model);
            this.heritageStatus(model.heritageStatus);
        }

        public final String getHeritageStatus() {
            return this.heritageStatus;
        }

        public final void setHeritageStatus(String heritageStatus) {
            this.heritageStatus = heritageStatus;
        }

        @Override
        public final Builder heritageStatus(String heritageStatus) {
            this.heritageStatus = heritageStatus;
            return this;
        }

        @Override
        public final Builder heritageStatus(HeritageStatus heritageStatus) {
            this.heritageStatus(heritageStatus == null ? null : heritageStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutTaxInheritanceRequest build() {
            return new PutTaxInheritanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TaxSettingsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutTaxInheritanceRequest> {
        public Builder heritageStatus(String var1);

        public Builder heritageStatus(HeritageStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

