/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.taxsettings.model.Address;
import software.amazon.awssdk.services.taxsettings.model.SupplementalTaxRegistrationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SupplementalTaxRegistrationEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SupplementalTaxRegistrationEntry> {
    private static final SdkField<Address> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("address").getter(SupplementalTaxRegistrationEntry.getter(SupplementalTaxRegistrationEntry::address)).setter(SupplementalTaxRegistrationEntry.setter(Builder::address)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("address").build()}).build();
    private static final SdkField<String> LEGAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("legalName").getter(SupplementalTaxRegistrationEntry.getter(SupplementalTaxRegistrationEntry::legalName)).setter(SupplementalTaxRegistrationEntry.setter(Builder::legalName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("legalName").build()}).build();
    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registrationId").getter(SupplementalTaxRegistrationEntry.getter(SupplementalTaxRegistrationEntry::registrationId)).setter(SupplementalTaxRegistrationEntry.setter(Builder::registrationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationId").build()}).build();
    private static final SdkField<String> REGISTRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registrationType").getter(SupplementalTaxRegistrationEntry.getter(SupplementalTaxRegistrationEntry::registrationTypeAsString)).setter(SupplementalTaxRegistrationEntry.setter(Builder::registrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD, LEGAL_NAME_FIELD, REGISTRATION_ID_FIELD, REGISTRATION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SupplementalTaxRegistrationEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Address address;
    private final String legalName;
    private final String registrationId;
    private final String registrationType;

    private SupplementalTaxRegistrationEntry(BuilderImpl builder) {
        this.address = builder.address;
        this.legalName = builder.legalName;
        this.registrationId = builder.registrationId;
        this.registrationType = builder.registrationType;
    }

    public final Address address() {
        return this.address;
    }

    public final String legalName() {
        return this.legalName;
    }

    public final String registrationId() {
        return this.registrationId;
    }

    public final SupplementalTaxRegistrationType registrationType() {
        return SupplementalTaxRegistrationType.fromValue(this.registrationType);
    }

    public final String registrationTypeAsString() {
        return this.registrationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.legalName());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupplementalTaxRegistrationEntry)) {
            return false;
        }
        SupplementalTaxRegistrationEntry other = (SupplementalTaxRegistrationEntry)obj;
        return Objects.equals(this.address(), other.address()) && Objects.equals(this.legalName(), other.legalName()) && Objects.equals(this.registrationId(), other.registrationId()) && Objects.equals(this.registrationTypeAsString(), other.registrationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SupplementalTaxRegistrationEntry").add("Address", (Object)this.address()).add("LegalName", (Object)this.legalName()).add("RegistrationId", (Object)this.registrationId()).add("RegistrationType", (Object)this.registrationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "legalName": {
                return Optional.ofNullable(clazz.cast(this.legalName()));
            }
            case "registrationId": {
                return Optional.ofNullable(clazz.cast(this.registrationId()));
            }
            case "registrationType": {
                return Optional.ofNullable(clazz.cast(this.registrationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("address", ADDRESS_FIELD);
        map.put("legalName", LEGAL_NAME_FIELD);
        map.put("registrationId", REGISTRATION_ID_FIELD);
        map.put("registrationType", REGISTRATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SupplementalTaxRegistrationEntry, T> g) {
        return obj -> g.apply((SupplementalTaxRegistrationEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Address address;
        private String legalName;
        private String registrationId;
        private String registrationType;

        private BuilderImpl() {
        }

        private BuilderImpl(SupplementalTaxRegistrationEntry model) {
            this.address(model.address);
            this.legalName(model.legalName);
            this.registrationId(model.registrationId);
            this.registrationType(model.registrationType);
        }

        public final Address.Builder getAddress() {
            return this.address != null ? this.address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final String getLegalName() {
            return this.legalName;
        }

        public final void setLegalName(String legalName) {
            this.legalName = legalName;
        }

        @Override
        public final Builder legalName(String legalName) {
            this.legalName = legalName;
            return this;
        }

        public final String getRegistrationId() {
            return this.registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final String getRegistrationType() {
            return this.registrationType;
        }

        public final void setRegistrationType(String registrationType) {
            this.registrationType = registrationType;
        }

        @Override
        public final Builder registrationType(String registrationType) {
            this.registrationType = registrationType;
            return this;
        }

        @Override
        public final Builder registrationType(SupplementalTaxRegistrationType registrationType) {
            this.registrationType(registrationType == null ? null : registrationType.toString());
            return this;
        }

        public SupplementalTaxRegistrationEntry build() {
            return new SupplementalTaxRegistrationEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SupplementalTaxRegistrationEntry> {
        public Builder address(Address var1);

        default public Builder address(Consumer<Address.Builder> address) {
            return this.address((Address)((Address.Builder)Address.builder().applyMutation(address)).build());
        }

        public Builder legalName(String var1);

        public Builder registrationId(String var1);

        public Builder registrationType(String var1);

        public Builder registrationType(SupplementalTaxRegistrationType var1);
    }
}

