/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PersonType {
    LEGAL_PERSON("Legal Person"),
    PHYSICAL_PERSON("Physical Person"),
    BUSINESS("Business"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PersonType> VALUE_MAP;
    private final String value;

    private PersonType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PersonType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PersonType> knownValues() {
        EnumSet<PersonType> knownValues = EnumSet.allOf(PersonType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PersonType.class, PersonType::toString);
    }
}

