/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.taxsettings.model.TaxExemptionType;
import software.amazon.awssdk.services.taxsettings.model.TaxExemptionTypesCopier;
import software.amazon.awssdk.services.taxsettings.model.TaxSettingsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTaxExemptionTypesResponse
extends TaxSettingsResponse
implements ToCopyableBuilder<Builder, GetTaxExemptionTypesResponse> {
    private static final SdkField<List<TaxExemptionType>> TAX_EXEMPTION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("taxExemptionTypes").getter(GetTaxExemptionTypesResponse.getter(GetTaxExemptionTypesResponse::taxExemptionTypes)).setter(GetTaxExemptionTypesResponse.setter(Builder::taxExemptionTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxExemptionTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaxExemptionType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAX_EXEMPTION_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTaxExemptionTypesResponse.memberNameToFieldInitializer();
    private final List<TaxExemptionType> taxExemptionTypes;

    private GetTaxExemptionTypesResponse(BuilderImpl builder) {
        super(builder);
        this.taxExemptionTypes = builder.taxExemptionTypes;
    }

    public final boolean hasTaxExemptionTypes() {
        return this.taxExemptionTypes != null && !(this.taxExemptionTypes instanceof SdkAutoConstructList);
    }

    public final List<TaxExemptionType> taxExemptionTypes() {
        return this.taxExemptionTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaxExemptionTypes() ? this.taxExemptionTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTaxExemptionTypesResponse)) {
            return false;
        }
        GetTaxExemptionTypesResponse other = (GetTaxExemptionTypesResponse)((Object)obj);
        return this.hasTaxExemptionTypes() == other.hasTaxExemptionTypes() && Objects.equals(this.taxExemptionTypes(), other.taxExemptionTypes());
    }

    public final String toString() {
        return ToString.builder((String)"GetTaxExemptionTypesResponse").add("TaxExemptionTypes", this.hasTaxExemptionTypes() ? this.taxExemptionTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taxExemptionTypes": {
                return Optional.ofNullable(clazz.cast(this.taxExemptionTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<TaxExemptionType>>> map = new HashMap<String, SdkField<List<TaxExemptionType>>>();
        map.put("taxExemptionTypes", TAX_EXEMPTION_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTaxExemptionTypesResponse, T> g) {
        return obj -> g.apply((GetTaxExemptionTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TaxSettingsResponse.BuilderImpl
    implements Builder {
        private List<TaxExemptionType> taxExemptionTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTaxExemptionTypesResponse model) {
            super(model);
            this.taxExemptionTypes(model.taxExemptionTypes);
        }

        public final List<TaxExemptionType.Builder> getTaxExemptionTypes() {
            List<TaxExemptionType.Builder> result = TaxExemptionTypesCopier.copyToBuilder(this.taxExemptionTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaxExemptionTypes(Collection<TaxExemptionType.BuilderImpl> taxExemptionTypes) {
            this.taxExemptionTypes = TaxExemptionTypesCopier.copyFromBuilder(taxExemptionTypes);
        }

        @Override
        public final Builder taxExemptionTypes(Collection<TaxExemptionType> taxExemptionTypes) {
            this.taxExemptionTypes = TaxExemptionTypesCopier.copy(taxExemptionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taxExemptionTypes(TaxExemptionType ... taxExemptionTypes) {
            this.taxExemptionTypes(Arrays.asList(taxExemptionTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taxExemptionTypes(Consumer<TaxExemptionType.Builder> ... taxExemptionTypes) {
            this.taxExemptionTypes(Stream.of(taxExemptionTypes).map(c -> (TaxExemptionType)((TaxExemptionType.Builder)TaxExemptionType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetTaxExemptionTypesResponse build() {
            return new GetTaxExemptionTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TaxSettingsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTaxExemptionTypesResponse> {
        public Builder taxExemptionTypes(Collection<TaxExemptionType> var1);

        public Builder taxExemptionTypes(TaxExemptionType ... var1);

        public Builder taxExemptionTypes(Consumer<TaxExemptionType.Builder> ... var1);
    }
}

