/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.synthetics.model.BrowserType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EngineConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EngineConfig> {
    private static final SdkField<String> ENGINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineArn").getter(EngineConfig.getter(EngineConfig::engineArn)).setter(EngineConfig.setter(Builder::engineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineArn").build()}).build();
    private static final SdkField<String> BROWSER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrowserType").getter(EngineConfig.getter(EngineConfig::browserTypeAsString)).setter(EngineConfig.setter(Builder::browserType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrowserType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_ARN_FIELD, BROWSER_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EngineConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String engineArn;
    private final String browserType;

    private EngineConfig(BuilderImpl builder) {
        this.engineArn = builder.engineArn;
        this.browserType = builder.browserType;
    }

    public final String engineArn() {
        return this.engineArn;
    }

    public final BrowserType browserType() {
        return BrowserType.fromValue(this.browserType);
    }

    public final String browserTypeAsString() {
        return this.browserType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.browserTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineConfig)) {
            return false;
        }
        EngineConfig other = (EngineConfig)obj;
        return Objects.equals(this.engineArn(), other.engineArn()) && Objects.equals(this.browserTypeAsString(), other.browserTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EngineConfig").add("EngineArn", (Object)this.engineArn()).add("BrowserType", (Object)this.browserTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EngineArn": {
                return Optional.ofNullable(clazz.cast(this.engineArn()));
            }
            case "BrowserType": {
                return Optional.ofNullable(clazz.cast(this.browserTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("EngineArn", ENGINE_ARN_FIELD);
        map.put("BrowserType", BROWSER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EngineConfig, T> g) {
        return obj -> g.apply((EngineConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String engineArn;
        private String browserType;

        private BuilderImpl() {
        }

        private BuilderImpl(EngineConfig model) {
            this.engineArn(model.engineArn);
            this.browserType(model.browserType);
        }

        public final String getEngineArn() {
            return this.engineArn;
        }

        public final void setEngineArn(String engineArn) {
            this.engineArn = engineArn;
        }

        @Override
        public final Builder engineArn(String engineArn) {
            this.engineArn = engineArn;
            return this;
        }

        public final String getBrowserType() {
            return this.browserType;
        }

        public final void setBrowserType(String browserType) {
            this.browserType = browserType;
        }

        @Override
        public final Builder browserType(String browserType) {
            this.browserType = browserType;
            return this;
        }

        @Override
        public final Builder browserType(BrowserType browserType) {
            this.browserType(browserType == null ? null : browserType.toString());
            return this;
        }

        public EngineConfig build() {
            return new EngineConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EngineConfig> {
        public Builder engineArn(String var1);

        public Builder browserType(String var1);

        public Builder browserType(BrowserType var1);
    }
}

