/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.synthetics.model.BlueprintTypesCopier;
import software.amazon.awssdk.services.synthetics.model.DependenciesCopier;
import software.amazon.awssdk.services.synthetics.model.Dependency;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CanaryCodeOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CanaryCodeOutput> {
    private static final SdkField<String> SOURCE_LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceLocationArn").getter(CanaryCodeOutput.getter(CanaryCodeOutput::sourceLocationArn)).setter(CanaryCodeOutput.setter(Builder::sourceLocationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationArn").build()}).build();
    private static final SdkField<String> HANDLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Handler").getter(CanaryCodeOutput.getter(CanaryCodeOutput::handler)).setter(CanaryCodeOutput.setter(Builder::handler)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Handler").build()}).build();
    private static final SdkField<List<String>> BLUEPRINT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlueprintTypes").getter(CanaryCodeOutput.getter(CanaryCodeOutput::blueprintTypes)).setter(CanaryCodeOutput.setter(Builder::blueprintTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueprintTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Dependency>> DEPENDENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Dependencies").getter(CanaryCodeOutput.getter(CanaryCodeOutput::dependencies)).setter(CanaryCodeOutput.setter(Builder::dependencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dependencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Dependency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_LOCATION_ARN_FIELD, HANDLER_FIELD, BLUEPRINT_TYPES_FIELD, DEPENDENCIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CanaryCodeOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceLocationArn;
    private final String handler;
    private final List<String> blueprintTypes;
    private final List<Dependency> dependencies;

    private CanaryCodeOutput(BuilderImpl builder) {
        this.sourceLocationArn = builder.sourceLocationArn;
        this.handler = builder.handler;
        this.blueprintTypes = builder.blueprintTypes;
        this.dependencies = builder.dependencies;
    }

    public final String sourceLocationArn() {
        return this.sourceLocationArn;
    }

    public final String handler() {
        return this.handler;
    }

    public final boolean hasBlueprintTypes() {
        return this.blueprintTypes != null && !(this.blueprintTypes instanceof SdkAutoConstructList);
    }

    public final List<String> blueprintTypes() {
        return this.blueprintTypes;
    }

    public final boolean hasDependencies() {
        return this.dependencies != null && !(this.dependencies instanceof SdkAutoConstructList);
    }

    public final List<Dependency> dependencies() {
        return this.dependencies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.handler());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlueprintTypes() ? this.blueprintTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependencies() ? this.dependencies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryCodeOutput)) {
            return false;
        }
        CanaryCodeOutput other = (CanaryCodeOutput)obj;
        return Objects.equals(this.sourceLocationArn(), other.sourceLocationArn()) && Objects.equals(this.handler(), other.handler()) && this.hasBlueprintTypes() == other.hasBlueprintTypes() && Objects.equals(this.blueprintTypes(), other.blueprintTypes()) && this.hasDependencies() == other.hasDependencies() && Objects.equals(this.dependencies(), other.dependencies());
    }

    public final String toString() {
        return ToString.builder((String)"CanaryCodeOutput").add("SourceLocationArn", (Object)this.sourceLocationArn()).add("Handler", (Object)this.handler()).add("BlueprintTypes", this.hasBlueprintTypes() ? this.blueprintTypes() : null).add("Dependencies", this.hasDependencies() ? this.dependencies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceLocationArn": {
                return Optional.ofNullable(clazz.cast(this.sourceLocationArn()));
            }
            case "Handler": {
                return Optional.ofNullable(clazz.cast(this.handler()));
            }
            case "BlueprintTypes": {
                return Optional.ofNullable(clazz.cast(this.blueprintTypes()));
            }
            case "Dependencies": {
                return Optional.ofNullable(clazz.cast(this.dependencies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceLocationArn", SOURCE_LOCATION_ARN_FIELD);
        map.put("Handler", HANDLER_FIELD);
        map.put("BlueprintTypes", BLUEPRINT_TYPES_FIELD);
        map.put("Dependencies", DEPENDENCIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CanaryCodeOutput, T> g) {
        return obj -> g.apply((CanaryCodeOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceLocationArn;
        private String handler;
        private List<String> blueprintTypes = DefaultSdkAutoConstructList.getInstance();
        private List<Dependency> dependencies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryCodeOutput model) {
            this.sourceLocationArn(model.sourceLocationArn);
            this.handler(model.handler);
            this.blueprintTypes(model.blueprintTypes);
            this.dependencies(model.dependencies);
        }

        public final String getSourceLocationArn() {
            return this.sourceLocationArn;
        }

        public final void setSourceLocationArn(String sourceLocationArn) {
            this.sourceLocationArn = sourceLocationArn;
        }

        @Override
        public final Builder sourceLocationArn(String sourceLocationArn) {
            this.sourceLocationArn = sourceLocationArn;
            return this;
        }

        public final String getHandler() {
            return this.handler;
        }

        public final void setHandler(String handler) {
            this.handler = handler;
        }

        @Override
        public final Builder handler(String handler) {
            this.handler = handler;
            return this;
        }

        public final Collection<String> getBlueprintTypes() {
            if (this.blueprintTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.blueprintTypes;
        }

        public final void setBlueprintTypes(Collection<String> blueprintTypes) {
            this.blueprintTypes = BlueprintTypesCopier.copy(blueprintTypes);
        }

        @Override
        public final Builder blueprintTypes(Collection<String> blueprintTypes) {
            this.blueprintTypes = BlueprintTypesCopier.copy(blueprintTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprintTypes(String ... blueprintTypes) {
            this.blueprintTypes(Arrays.asList(blueprintTypes));
            return this;
        }

        public final List<Dependency.Builder> getDependencies() {
            List<Dependency.Builder> result = DependenciesCopier.copyToBuilder(this.dependencies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependencies(Collection<Dependency.BuilderImpl> dependencies) {
            this.dependencies = DependenciesCopier.copyFromBuilder(dependencies);
        }

        @Override
        public final Builder dependencies(Collection<Dependency> dependencies) {
            this.dependencies = DependenciesCopier.copy(dependencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(Dependency ... dependencies) {
            this.dependencies(Arrays.asList(dependencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(Consumer<Dependency.Builder> ... dependencies) {
            this.dependencies(Stream.of(dependencies).map(c -> (Dependency)((Dependency.Builder)Dependency.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CanaryCodeOutput build() {
            return new CanaryCodeOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CanaryCodeOutput> {
        public Builder sourceLocationArn(String var1);

        public Builder handler(String var1);

        public Builder blueprintTypes(Collection<String> var1);

        public Builder blueprintTypes(String ... var1);

        public Builder dependencies(Collection<Dependency> var1);

        public Builder dependencies(Dependency ... var1);

        public Builder dependencies(Consumer<Dependency.Builder> ... var1);
    }
}

