/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceToTag {
    LAMBDA_FUNCTION("lambda-function"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceToTag> VALUE_MAP;
    private final String value;

    private ResourceToTag(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceToTag fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceToTag> knownValues() {
        EnumSet<ResourceToTag> knownValues = EnumSet.allOf(ResourceToTag.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceToTag.class, ResourceToTag::toString);
    }
}

