/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.synthetics.model.BrowserType;
import software.amazon.awssdk.services.synthetics.model.CanaryDryRunConfigOutput;
import software.amazon.awssdk.services.synthetics.model.CanaryRunStatus;
import software.amazon.awssdk.services.synthetics.model.CanaryRunTimeline;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CanaryRun
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CanaryRun> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CanaryRun.getter(CanaryRun::id)).setter(CanaryRun.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> SCHEDULED_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduledRunId").getter(CanaryRun.getter(CanaryRun::scheduledRunId)).setter(CanaryRun.setter(Builder::scheduledRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledRunId").build()}).build();
    private static final SdkField<Integer> RETRY_ATTEMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetryAttempt").getter(CanaryRun.getter(CanaryRun::retryAttempt)).setter(CanaryRun.setter(Builder::retryAttempt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryAttempt").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CanaryRun.getter(CanaryRun::name)).setter(CanaryRun.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<CanaryRunStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(CanaryRun.getter(CanaryRun::status)).setter(CanaryRun.setter(Builder::status)).constructor(CanaryRunStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<CanaryRunTimeline> TIMELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Timeline").getter(CanaryRun.getter(CanaryRun::timeline)).setter(CanaryRun.setter(Builder::timeline)).constructor(CanaryRunTimeline::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeline").build()}).build();
    private static final SdkField<String> ARTIFACT_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactS3Location").getter(CanaryRun.getter(CanaryRun::artifactS3Location)).setter(CanaryRun.setter(Builder::artifactS3Location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactS3Location").build()}).build();
    private static final SdkField<CanaryDryRunConfigOutput> DRY_RUN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DryRunConfig").getter(CanaryRun.getter(CanaryRun::dryRunConfig)).setter(CanaryRun.setter(Builder::dryRunConfig)).constructor(CanaryDryRunConfigOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRunConfig").build()}).build();
    private static final SdkField<String> BROWSER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrowserType").getter(CanaryRun.getter(CanaryRun::browserTypeAsString)).setter(CanaryRun.setter(Builder::browserType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrowserType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SCHEDULED_RUN_ID_FIELD, RETRY_ATTEMPT_FIELD, NAME_FIELD, STATUS_FIELD, TIMELINE_FIELD, ARTIFACT_S3_LOCATION_FIELD, DRY_RUN_CONFIG_FIELD, BROWSER_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CanaryRun.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String scheduledRunId;
    private final Integer retryAttempt;
    private final String name;
    private final CanaryRunStatus status;
    private final CanaryRunTimeline timeline;
    private final String artifactS3Location;
    private final CanaryDryRunConfigOutput dryRunConfig;
    private final String browserType;

    private CanaryRun(BuilderImpl builder) {
        this.id = builder.id;
        this.scheduledRunId = builder.scheduledRunId;
        this.retryAttempt = builder.retryAttempt;
        this.name = builder.name;
        this.status = builder.status;
        this.timeline = builder.timeline;
        this.artifactS3Location = builder.artifactS3Location;
        this.dryRunConfig = builder.dryRunConfig;
        this.browserType = builder.browserType;
    }

    public final String id() {
        return this.id;
    }

    public final String scheduledRunId() {
        return this.scheduledRunId;
    }

    public final Integer retryAttempt() {
        return this.retryAttempt;
    }

    public final String name() {
        return this.name;
    }

    public final CanaryRunStatus status() {
        return this.status;
    }

    public final CanaryRunTimeline timeline() {
        return this.timeline;
    }

    public final String artifactS3Location() {
        return this.artifactS3Location;
    }

    public final CanaryDryRunConfigOutput dryRunConfig() {
        return this.dryRunConfig;
    }

    public final BrowserType browserType() {
        return BrowserType.fromValue(this.browserType);
    }

    public final String browserTypeAsString() {
        return this.browserType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryAttempt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeline());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRunConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.browserTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryRun)) {
            return false;
        }
        CanaryRun other = (CanaryRun)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.scheduledRunId(), other.scheduledRunId()) && Objects.equals(this.retryAttempt(), other.retryAttempt()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.timeline(), other.timeline()) && Objects.equals(this.artifactS3Location(), other.artifactS3Location()) && Objects.equals(this.dryRunConfig(), other.dryRunConfig()) && Objects.equals(this.browserTypeAsString(), other.browserTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CanaryRun").add("Id", (Object)this.id()).add("ScheduledRunId", (Object)this.scheduledRunId()).add("RetryAttempt", (Object)this.retryAttempt()).add("Name", (Object)this.name()).add("Status", (Object)this.status()).add("Timeline", (Object)this.timeline()).add("ArtifactS3Location", (Object)this.artifactS3Location()).add("DryRunConfig", (Object)this.dryRunConfig()).add("BrowserType", (Object)this.browserTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ScheduledRunId": {
                return Optional.ofNullable(clazz.cast(this.scheduledRunId()));
            }
            case "RetryAttempt": {
                return Optional.ofNullable(clazz.cast(this.retryAttempt()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Timeline": {
                return Optional.ofNullable(clazz.cast(this.timeline()));
            }
            case "ArtifactS3Location": {
                return Optional.ofNullable(clazz.cast(this.artifactS3Location()));
            }
            case "DryRunConfig": {
                return Optional.ofNullable(clazz.cast(this.dryRunConfig()));
            }
            case "BrowserType": {
                return Optional.ofNullable(clazz.cast(this.browserTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("ScheduledRunId", SCHEDULED_RUN_ID_FIELD);
        map.put("RetryAttempt", RETRY_ATTEMPT_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Timeline", TIMELINE_FIELD);
        map.put("ArtifactS3Location", ARTIFACT_S3_LOCATION_FIELD);
        map.put("DryRunConfig", DRY_RUN_CONFIG_FIELD);
        map.put("BrowserType", BROWSER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CanaryRun, T> g) {
        return obj -> g.apply((CanaryRun)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String scheduledRunId;
        private Integer retryAttempt;
        private String name;
        private CanaryRunStatus status;
        private CanaryRunTimeline timeline;
        private String artifactS3Location;
        private CanaryDryRunConfigOutput dryRunConfig;
        private String browserType;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryRun model) {
            this.id(model.id);
            this.scheduledRunId(model.scheduledRunId);
            this.retryAttempt(model.retryAttempt);
            this.name(model.name);
            this.status(model.status);
            this.timeline(model.timeline);
            this.artifactS3Location(model.artifactS3Location);
            this.dryRunConfig(model.dryRunConfig);
            this.browserType(model.browserType);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getScheduledRunId() {
            return this.scheduledRunId;
        }

        public final void setScheduledRunId(String scheduledRunId) {
            this.scheduledRunId = scheduledRunId;
        }

        @Override
        public final Builder scheduledRunId(String scheduledRunId) {
            this.scheduledRunId = scheduledRunId;
            return this;
        }

        public final Integer getRetryAttempt() {
            return this.retryAttempt;
        }

        public final void setRetryAttempt(Integer retryAttempt) {
            this.retryAttempt = retryAttempt;
        }

        @Override
        public final Builder retryAttempt(Integer retryAttempt) {
            this.retryAttempt = retryAttempt;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CanaryRunStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(CanaryRunStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(CanaryRunStatus status) {
            this.status = status;
            return this;
        }

        public final CanaryRunTimeline.Builder getTimeline() {
            return this.timeline != null ? this.timeline.toBuilder() : null;
        }

        public final void setTimeline(CanaryRunTimeline.BuilderImpl timeline) {
            this.timeline = timeline != null ? timeline.build() : null;
        }

        @Override
        public final Builder timeline(CanaryRunTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        public final String getArtifactS3Location() {
            return this.artifactS3Location;
        }

        public final void setArtifactS3Location(String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
        }

        @Override
        public final Builder artifactS3Location(String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
            return this;
        }

        public final CanaryDryRunConfigOutput.Builder getDryRunConfig() {
            return this.dryRunConfig != null ? this.dryRunConfig.toBuilder() : null;
        }

        public final void setDryRunConfig(CanaryDryRunConfigOutput.BuilderImpl dryRunConfig) {
            this.dryRunConfig = dryRunConfig != null ? dryRunConfig.build() : null;
        }

        @Override
        public final Builder dryRunConfig(CanaryDryRunConfigOutput dryRunConfig) {
            this.dryRunConfig = dryRunConfig;
            return this;
        }

        public final String getBrowserType() {
            return this.browserType;
        }

        public final void setBrowserType(String browserType) {
            this.browserType = browserType;
        }

        @Override
        public final Builder browserType(String browserType) {
            this.browserType = browserType;
            return this;
        }

        @Override
        public final Builder browserType(BrowserType browserType) {
            this.browserType(browserType == null ? null : browserType.toString());
            return this;
        }

        public CanaryRun build() {
            return new CanaryRun(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CanaryRun> {
        public Builder id(String var1);

        public Builder scheduledRunId(String var1);

        public Builder retryAttempt(Integer var1);

        public Builder name(String var1);

        public Builder status(CanaryRunStatus var1);

        default public Builder status(Consumer<CanaryRunStatus.Builder> status) {
            return this.status((CanaryRunStatus)((CanaryRunStatus.Builder)CanaryRunStatus.builder().applyMutation(status)).build());
        }

        public Builder timeline(CanaryRunTimeline var1);

        default public Builder timeline(Consumer<CanaryRunTimeline.Builder> timeline) {
            return this.timeline((CanaryRunTimeline)((CanaryRunTimeline.Builder)CanaryRunTimeline.builder().applyMutation(timeline)).build());
        }

        public Builder artifactS3Location(String var1);

        public Builder dryRunConfig(CanaryDryRunConfigOutput var1);

        default public Builder dryRunConfig(Consumer<CanaryDryRunConfigOutput.Builder> dryRunConfig) {
            return this.dryRunConfig((CanaryDryRunConfigOutput)((CanaryDryRunConfigOutput.Builder)CanaryDryRunConfigOutput.builder().applyMutation(dryRunConfig)).build());
        }

        public Builder browserType(String var1);

        public Builder browserType(BrowserType var1);
    }
}

