/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.ChildPolicy;
import software.amazon.awssdk.services.swf.model.SwfRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TerminateWorkflowExecutionRequest
extends SwfRequest
implements ToCopyableBuilder<Builder, TerminateWorkflowExecutionRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(TerminateWorkflowExecutionRequest.getter(TerminateWorkflowExecutionRequest::domain)).setter(TerminateWorkflowExecutionRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()}).build();
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowId").getter(TerminateWorkflowExecutionRequest.getter(TerminateWorkflowExecutionRequest::workflowId)).setter(TerminateWorkflowExecutionRequest.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runId").getter(TerminateWorkflowExecutionRequest.getter(TerminateWorkflowExecutionRequest::runId)).setter(TerminateWorkflowExecutionRequest.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(TerminateWorkflowExecutionRequest.getter(TerminateWorkflowExecutionRequest::reason)).setter(TerminateWorkflowExecutionRequest.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<String> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("details").getter(TerminateWorkflowExecutionRequest.getter(TerminateWorkflowExecutionRequest::details)).setter(TerminateWorkflowExecutionRequest.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()}).build();
    private static final SdkField<String> CHILD_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("childPolicy").getter(TerminateWorkflowExecutionRequest.getter(TerminateWorkflowExecutionRequest::childPolicyAsString)).setter(TerminateWorkflowExecutionRequest.setter(Builder::childPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, WORKFLOW_ID_FIELD, RUN_ID_FIELD, REASON_FIELD, DETAILS_FIELD, CHILD_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TerminateWorkflowExecutionRequest.memberNameToFieldInitializer();
    private final String domain;
    private final String workflowId;
    private final String runId;
    private final String reason;
    private final String details;
    private final String childPolicy;

    private TerminateWorkflowExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.workflowId = builder.workflowId;
        this.runId = builder.runId;
        this.reason = builder.reason;
        this.details = builder.details;
        this.childPolicy = builder.childPolicy;
    }

    public final String domain() {
        return this.domain;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final String runId() {
        return this.runId;
    }

    public final String reason() {
        return this.reason;
    }

    public final String details() {
        return this.details;
    }

    public final ChildPolicy childPolicy() {
        return ChildPolicy.fromValue(this.childPolicy);
    }

    public final String childPolicyAsString() {
        return this.childPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        hashCode = 31 * hashCode + Objects.hashCode(this.childPolicyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateWorkflowExecutionRequest)) {
            return false;
        }
        TerminateWorkflowExecutionRequest other = (TerminateWorkflowExecutionRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.runId(), other.runId()) && Objects.equals(this.reason(), other.reason()) && Objects.equals(this.details(), other.details()) && Objects.equals(this.childPolicyAsString(), other.childPolicyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TerminateWorkflowExecutionRequest").add("Domain", (Object)this.domain()).add("WorkflowId", (Object)this.workflowId()).add("RunId", (Object)this.runId()).add("Reason", (Object)this.reason()).add("Details", (Object)this.details()).add("ChildPolicy", (Object)this.childPolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "workflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "runId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
            case "childPolicy": {
                return Optional.ofNullable(clazz.cast(this.childPolicyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("domain", DOMAIN_FIELD);
        map.put("workflowId", WORKFLOW_ID_FIELD);
        map.put("runId", RUN_ID_FIELD);
        map.put("reason", REASON_FIELD);
        map.put("details", DETAILS_FIELD);
        map.put("childPolicy", CHILD_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TerminateWorkflowExecutionRequest, T> g) {
        return obj -> g.apply((TerminateWorkflowExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfRequest.BuilderImpl
    implements Builder {
        private String domain;
        private String workflowId;
        private String runId;
        private String reason;
        private String details;
        private String childPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateWorkflowExecutionRequest model) {
            super(model);
            this.domain(model.domain);
            this.workflowId(model.workflowId);
            this.runId(model.runId);
            this.reason(model.reason);
            this.details(model.details);
            this.childPolicy(model.childPolicy);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final String getDetails() {
            return this.details;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final String getChildPolicy() {
            return this.childPolicy;
        }

        public final void setChildPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
        }

        @Override
        public final Builder childPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
            return this;
        }

        @Override
        public final Builder childPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy == null ? null : childPolicy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TerminateWorkflowExecutionRequest build() {
            return new TerminateWorkflowExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SwfRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TerminateWorkflowExecutionRequest> {
        public Builder domain(String var1);

        public Builder workflowId(String var1);

        public Builder runId(String var1);

        public Builder reason(String var1);

        public Builder details(String var1);

        public Builder childPolicy(String var1);

        public Builder childPolicy(ChildPolicy var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

