/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.swf.model.ChildPolicy;
import software.amazon.awssdk.services.swf.model.TagListCopier;
import software.amazon.awssdk.services.swf.model.TaskList;
import software.amazon.awssdk.services.swf.model.WorkflowExecution;
import software.amazon.awssdk.services.swf.model.WorkflowType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowExecutionStartedEventAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowExecutionStartedEventAttributes> {
    private static final SdkField<String> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("input").getter(WorkflowExecutionStartedEventAttributes.getter(WorkflowExecutionStartedEventAttributes::input)).setter(WorkflowExecutionStartedEventAttributes.setter(Builder::input)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<String> EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionStartToCloseTimeout").getter(WorkflowExecutionStartedEventAttributes.getter(WorkflowExecutionStartedEventAttributes::executionStartToCloseTimeout)).setter(WorkflowExecutionStartedEventAttributes.setter(Builder::executionStartToCloseTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStartToCloseTimeout").build()}).build();
    private static final SdkField<String> TASK_START_TO_CLOSE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskStartToCloseTimeout").getter(WorkflowExecutionStartedEventAttributes.getter(WorkflowExecutionStartedEventAttributes::taskStartToCloseTimeout)).setter(WorkflowExecutionStartedEventAttributes.setter(Builder::taskStartToCloseTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStartToCloseTimeout").build()}).build();
    private static final SdkField<String> CHILD_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("childPolicy").getter(WorkflowExecutionStartedEventAttributes.getter(WorkflowExecutionStartedEventAttributes::childPolicyAsString)).setter(WorkflowExecutionStartedEventAttributes.setter(Builder::childPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childPolicy").build()}).build();
    private static final SdkField<TaskList> TASK_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("taskList").getter(WorkflowExecutionStartedEventAttributes.getter(WorkflowExecutionStartedEventAttributes::taskList)).setter(WorkflowExecutionStartedEventAttributes.setter(Builder::taskList)).constructor(TaskList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskList").build()}).build();
    private static final SdkField<String> TASK_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskPriority").getter(WorkflowExecutionStartedEventAttributes.getter(WorkflowExecutionStartedEventAttributes::taskPriority)).setter(WorkflowExecutionStartedEventAttributes.setter(Builder::taskPriority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskPriority").build()}).build();
    private static final SdkField<WorkflowType> WORKFLOW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("workflowType").getter(WorkflowExecutionStartedEventAttributes.getter(WorkflowExecutionStartedEventAttributes::workflowType)).setter(WorkflowExecutionStartedEventAttributes.setter(Builder::workflowType)).constructor(WorkflowType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()}).build();
    private static final SdkField<List<String>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tagList").getter(WorkflowExecutionStartedEventAttributes.getter(WorkflowExecutionStartedEventAttributes::tagList)).setter(WorkflowExecutionStartedEventAttributes.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONTINUED_EXECUTION_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("continuedExecutionRunId").getter(WorkflowExecutionStartedEventAttributes.getter(WorkflowExecutionStartedEventAttributes::continuedExecutionRunId)).setter(WorkflowExecutionStartedEventAttributes.setter(Builder::continuedExecutionRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuedExecutionRunId").build()}).build();
    private static final SdkField<WorkflowExecution> PARENT_WORKFLOW_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("parentWorkflowExecution").getter(WorkflowExecutionStartedEventAttributes.getter(WorkflowExecutionStartedEventAttributes::parentWorkflowExecution)).setter(WorkflowExecutionStartedEventAttributes.setter(Builder::parentWorkflowExecution)).constructor(WorkflowExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentWorkflowExecution").build()}).build();
    private static final SdkField<Long> PARENT_INITIATED_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("parentInitiatedEventId").getter(WorkflowExecutionStartedEventAttributes.getter(WorkflowExecutionStartedEventAttributes::parentInitiatedEventId)).setter(WorkflowExecutionStartedEventAttributes.setter(Builder::parentInitiatedEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentInitiatedEventId").build()}).build();
    private static final SdkField<String> LAMBDA_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lambdaRole").getter(WorkflowExecutionStartedEventAttributes.getter(WorkflowExecutionStartedEventAttributes::lambdaRole)).setter(WorkflowExecutionStartedEventAttributes.setter(Builder::lambdaRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD, EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD, TASK_START_TO_CLOSE_TIMEOUT_FIELD, CHILD_POLICY_FIELD, TASK_LIST_FIELD, TASK_PRIORITY_FIELD, WORKFLOW_TYPE_FIELD, TAG_LIST_FIELD, CONTINUED_EXECUTION_RUN_ID_FIELD, PARENT_WORKFLOW_EXECUTION_FIELD, PARENT_INITIATED_EVENT_ID_FIELD, LAMBDA_ROLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkflowExecutionStartedEventAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String input;
    private final String executionStartToCloseTimeout;
    private final String taskStartToCloseTimeout;
    private final String childPolicy;
    private final TaskList taskList;
    private final String taskPriority;
    private final WorkflowType workflowType;
    private final List<String> tagList;
    private final String continuedExecutionRunId;
    private final WorkflowExecution parentWorkflowExecution;
    private final Long parentInitiatedEventId;
    private final String lambdaRole;

    private WorkflowExecutionStartedEventAttributes(BuilderImpl builder) {
        this.input = builder.input;
        this.executionStartToCloseTimeout = builder.executionStartToCloseTimeout;
        this.taskStartToCloseTimeout = builder.taskStartToCloseTimeout;
        this.childPolicy = builder.childPolicy;
        this.taskList = builder.taskList;
        this.taskPriority = builder.taskPriority;
        this.workflowType = builder.workflowType;
        this.tagList = builder.tagList;
        this.continuedExecutionRunId = builder.continuedExecutionRunId;
        this.parentWorkflowExecution = builder.parentWorkflowExecution;
        this.parentInitiatedEventId = builder.parentInitiatedEventId;
        this.lambdaRole = builder.lambdaRole;
    }

    public final String input() {
        return this.input;
    }

    public final String executionStartToCloseTimeout() {
        return this.executionStartToCloseTimeout;
    }

    public final String taskStartToCloseTimeout() {
        return this.taskStartToCloseTimeout;
    }

    public final ChildPolicy childPolicy() {
        return ChildPolicy.fromValue(this.childPolicy);
    }

    public final String childPolicyAsString() {
        return this.childPolicy;
    }

    public final TaskList taskList() {
        return this.taskList;
    }

    public final String taskPriority() {
        return this.taskPriority;
    }

    public final WorkflowType workflowType() {
        return this.workflowType;
    }

    public final boolean hasTagList() {
        return this.tagList != null && !(this.tagList instanceof SdkAutoConstructList);
    }

    public final List<String> tagList() {
        return this.tagList;
    }

    public final String continuedExecutionRunId() {
        return this.continuedExecutionRunId;
    }

    public final WorkflowExecution parentWorkflowExecution() {
        return this.parentWorkflowExecution;
    }

    public final Long parentInitiatedEventId() {
        return this.parentInitiatedEventId;
    }

    public final String lambdaRole() {
        return this.lambdaRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.childPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskList());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskPriority());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagList() ? this.tagList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.continuedExecutionRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentWorkflowExecution());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentInitiatedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionStartedEventAttributes)) {
            return false;
        }
        WorkflowExecutionStartedEventAttributes other = (WorkflowExecutionStartedEventAttributes)obj;
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.executionStartToCloseTimeout(), other.executionStartToCloseTimeout()) && Objects.equals(this.taskStartToCloseTimeout(), other.taskStartToCloseTimeout()) && Objects.equals(this.childPolicyAsString(), other.childPolicyAsString()) && Objects.equals(this.taskList(), other.taskList()) && Objects.equals(this.taskPriority(), other.taskPriority()) && Objects.equals(this.workflowType(), other.workflowType()) && this.hasTagList() == other.hasTagList() && Objects.equals(this.tagList(), other.tagList()) && Objects.equals(this.continuedExecutionRunId(), other.continuedExecutionRunId()) && Objects.equals(this.parentWorkflowExecution(), other.parentWorkflowExecution()) && Objects.equals(this.parentInitiatedEventId(), other.parentInitiatedEventId()) && Objects.equals(this.lambdaRole(), other.lambdaRole());
    }

    public final String toString() {
        return ToString.builder((String)"WorkflowExecutionStartedEventAttributes").add("Input", (Object)this.input()).add("ExecutionStartToCloseTimeout", (Object)this.executionStartToCloseTimeout()).add("TaskStartToCloseTimeout", (Object)this.taskStartToCloseTimeout()).add("ChildPolicy", (Object)this.childPolicyAsString()).add("TaskList", (Object)this.taskList()).add("TaskPriority", (Object)this.taskPriority()).add("WorkflowType", (Object)this.workflowType()).add("TagList", this.hasTagList() ? this.tagList() : null).add("ContinuedExecutionRunId", (Object)this.continuedExecutionRunId()).add("ParentWorkflowExecution", (Object)this.parentWorkflowExecution()).add("ParentInitiatedEventId", (Object)this.parentInitiatedEventId()).add("LambdaRole", (Object)this.lambdaRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "executionStartToCloseTimeout": {
                return Optional.ofNullable(clazz.cast(this.executionStartToCloseTimeout()));
            }
            case "taskStartToCloseTimeout": {
                return Optional.ofNullable(clazz.cast(this.taskStartToCloseTimeout()));
            }
            case "childPolicy": {
                return Optional.ofNullable(clazz.cast(this.childPolicyAsString()));
            }
            case "taskList": {
                return Optional.ofNullable(clazz.cast(this.taskList()));
            }
            case "taskPriority": {
                return Optional.ofNullable(clazz.cast(this.taskPriority()));
            }
            case "workflowType": {
                return Optional.ofNullable(clazz.cast(this.workflowType()));
            }
            case "tagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
            case "continuedExecutionRunId": {
                return Optional.ofNullable(clazz.cast(this.continuedExecutionRunId()));
            }
            case "parentWorkflowExecution": {
                return Optional.ofNullable(clazz.cast(this.parentWorkflowExecution()));
            }
            case "parentInitiatedEventId": {
                return Optional.ofNullable(clazz.cast(this.parentInitiatedEventId()));
            }
            case "lambdaRole": {
                return Optional.ofNullable(clazz.cast(this.lambdaRole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("input", INPUT_FIELD);
        map.put("executionStartToCloseTimeout", EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD);
        map.put("taskStartToCloseTimeout", TASK_START_TO_CLOSE_TIMEOUT_FIELD);
        map.put("childPolicy", CHILD_POLICY_FIELD);
        map.put("taskList", TASK_LIST_FIELD);
        map.put("taskPriority", TASK_PRIORITY_FIELD);
        map.put("workflowType", WORKFLOW_TYPE_FIELD);
        map.put("tagList", TAG_LIST_FIELD);
        map.put("continuedExecutionRunId", CONTINUED_EXECUTION_RUN_ID_FIELD);
        map.put("parentWorkflowExecution", PARENT_WORKFLOW_EXECUTION_FIELD);
        map.put("parentInitiatedEventId", PARENT_INITIATED_EVENT_ID_FIELD);
        map.put("lambdaRole", LAMBDA_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkflowExecutionStartedEventAttributes, T> g) {
        return obj -> g.apply((WorkflowExecutionStartedEventAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String input;
        private String executionStartToCloseTimeout;
        private String taskStartToCloseTimeout;
        private String childPolicy;
        private TaskList taskList;
        private String taskPriority;
        private WorkflowType workflowType;
        private List<String> tagList = DefaultSdkAutoConstructList.getInstance();
        private String continuedExecutionRunId;
        private WorkflowExecution parentWorkflowExecution;
        private Long parentInitiatedEventId;
        private String lambdaRole;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionStartedEventAttributes model) {
            this.input(model.input);
            this.executionStartToCloseTimeout(model.executionStartToCloseTimeout);
            this.taskStartToCloseTimeout(model.taskStartToCloseTimeout);
            this.childPolicy(model.childPolicy);
            this.taskList(model.taskList);
            this.taskPriority(model.taskPriority);
            this.workflowType(model.workflowType);
            this.tagList(model.tagList);
            this.continuedExecutionRunId(model.continuedExecutionRunId);
            this.parentWorkflowExecution(model.parentWorkflowExecution);
            this.parentInitiatedEventId(model.parentInitiatedEventId);
            this.lambdaRole(model.lambdaRole);
        }

        public final String getInput() {
            return this.input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final String getExecutionStartToCloseTimeout() {
            return this.executionStartToCloseTimeout;
        }

        public final void setExecutionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
        }

        @Override
        public final Builder executionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
            return this;
        }

        public final String getTaskStartToCloseTimeout() {
            return this.taskStartToCloseTimeout;
        }

        public final void setTaskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
        }

        @Override
        public final Builder taskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
            return this;
        }

        public final String getChildPolicy() {
            return this.childPolicy;
        }

        public final void setChildPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
        }

        @Override
        public final Builder childPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
            return this;
        }

        @Override
        public final Builder childPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy == null ? null : childPolicy.toString());
            return this;
        }

        public final TaskList.Builder getTaskList() {
            return this.taskList != null ? this.taskList.toBuilder() : null;
        }

        public final void setTaskList(TaskList.BuilderImpl taskList) {
            this.taskList = taskList != null ? taskList.build() : null;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final String getTaskPriority() {
            return this.taskPriority;
        }

        public final void setTaskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
        }

        @Override
        public final Builder taskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public final WorkflowType.Builder getWorkflowType() {
            return this.workflowType != null ? this.workflowType.toBuilder() : null;
        }

        public final void setWorkflowType(WorkflowType.BuilderImpl workflowType) {
            this.workflowType = workflowType != null ? workflowType.build() : null;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final Collection<String> getTagList() {
            if (this.tagList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagList;
        }

        public final void setTagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
        }

        @Override
        public final Builder tagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(String ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        public final String getContinuedExecutionRunId() {
            return this.continuedExecutionRunId;
        }

        public final void setContinuedExecutionRunId(String continuedExecutionRunId) {
            this.continuedExecutionRunId = continuedExecutionRunId;
        }

        @Override
        public final Builder continuedExecutionRunId(String continuedExecutionRunId) {
            this.continuedExecutionRunId = continuedExecutionRunId;
            return this;
        }

        public final WorkflowExecution.Builder getParentWorkflowExecution() {
            return this.parentWorkflowExecution != null ? this.parentWorkflowExecution.toBuilder() : null;
        }

        public final void setParentWorkflowExecution(WorkflowExecution.BuilderImpl parentWorkflowExecution) {
            this.parentWorkflowExecution = parentWorkflowExecution != null ? parentWorkflowExecution.build() : null;
        }

        @Override
        public final Builder parentWorkflowExecution(WorkflowExecution parentWorkflowExecution) {
            this.parentWorkflowExecution = parentWorkflowExecution;
            return this;
        }

        public final Long getParentInitiatedEventId() {
            return this.parentInitiatedEventId;
        }

        public final void setParentInitiatedEventId(Long parentInitiatedEventId) {
            this.parentInitiatedEventId = parentInitiatedEventId;
        }

        @Override
        public final Builder parentInitiatedEventId(Long parentInitiatedEventId) {
            this.parentInitiatedEventId = parentInitiatedEventId;
            return this;
        }

        public final String getLambdaRole() {
            return this.lambdaRole;
        }

        public final void setLambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
        }

        @Override
        public final Builder lambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
            return this;
        }

        public WorkflowExecutionStartedEventAttributes build() {
            return new WorkflowExecutionStartedEventAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowExecutionStartedEventAttributes> {
        public Builder input(String var1);

        public Builder executionStartToCloseTimeout(String var1);

        public Builder taskStartToCloseTimeout(String var1);

        public Builder childPolicy(String var1);

        public Builder childPolicy(ChildPolicy var1);

        public Builder taskList(TaskList var1);

        default public Builder taskList(Consumer<TaskList.Builder> taskList) {
            return this.taskList((TaskList)((TaskList.Builder)TaskList.builder().applyMutation(taskList)).build());
        }

        public Builder taskPriority(String var1);

        public Builder workflowType(WorkflowType var1);

        default public Builder workflowType(Consumer<WorkflowType.Builder> workflowType) {
            return this.workflowType((WorkflowType)((WorkflowType.Builder)WorkflowType.builder().applyMutation(workflowType)).build());
        }

        public Builder tagList(Collection<String> var1);

        public Builder tagList(String ... var1);

        public Builder continuedExecutionRunId(String var1);

        public Builder parentWorkflowExecution(WorkflowExecution var1);

        default public Builder parentWorkflowExecution(Consumer<WorkflowExecution.Builder> parentWorkflowExecution) {
            return this.parentWorkflowExecution((WorkflowExecution)((WorkflowExecution.Builder)WorkflowExecution.builder().applyMutation(parentWorkflowExecution)).build());
        }

        public Builder parentInitiatedEventId(Long var1);

        public Builder lambdaRole(String var1);
    }
}

