/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowDedupeStrategy;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowLoadType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataIntegrationFlowDatasetOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataIntegrationFlowDatasetOptions> {
    private static final SdkField<String> LOAD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("loadType").getter(DataIntegrationFlowDatasetOptions.getter(DataIntegrationFlowDatasetOptions::loadTypeAsString)).setter(DataIntegrationFlowDatasetOptions.setter(Builder::loadType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadType").build()}).build();
    private static final SdkField<Boolean> DEDUPE_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("dedupeRecords").getter(DataIntegrationFlowDatasetOptions.getter(DataIntegrationFlowDatasetOptions::dedupeRecords)).setter(DataIntegrationFlowDatasetOptions.setter(Builder::dedupeRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dedupeRecords").build()}).build();
    private static final SdkField<DataIntegrationFlowDedupeStrategy> DEDUPE_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dedupeStrategy").getter(DataIntegrationFlowDatasetOptions.getter(DataIntegrationFlowDatasetOptions::dedupeStrategy)).setter(DataIntegrationFlowDatasetOptions.setter(Builder::dedupeStrategy)).constructor(DataIntegrationFlowDedupeStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dedupeStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_TYPE_FIELD, DEDUPE_RECORDS_FIELD, DEDUPE_STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataIntegrationFlowDatasetOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String loadType;
    private final Boolean dedupeRecords;
    private final DataIntegrationFlowDedupeStrategy dedupeStrategy;

    private DataIntegrationFlowDatasetOptions(BuilderImpl builder) {
        this.loadType = builder.loadType;
        this.dedupeRecords = builder.dedupeRecords;
        this.dedupeStrategy = builder.dedupeStrategy;
    }

    public final DataIntegrationFlowLoadType loadType() {
        return DataIntegrationFlowLoadType.fromValue(this.loadType);
    }

    public final String loadTypeAsString() {
        return this.loadType;
    }

    public final Boolean dedupeRecords() {
        return this.dedupeRecords;
    }

    public final DataIntegrationFlowDedupeStrategy dedupeStrategy() {
        return this.dedupeStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedupeRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedupeStrategy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationFlowDatasetOptions)) {
            return false;
        }
        DataIntegrationFlowDatasetOptions other = (DataIntegrationFlowDatasetOptions)obj;
        return Objects.equals(this.loadTypeAsString(), other.loadTypeAsString()) && Objects.equals(this.dedupeRecords(), other.dedupeRecords()) && Objects.equals(this.dedupeStrategy(), other.dedupeStrategy());
    }

    public final String toString() {
        return ToString.builder((String)"DataIntegrationFlowDatasetOptions").add("LoadType", (Object)this.loadTypeAsString()).add("DedupeRecords", (Object)this.dedupeRecords()).add("DedupeStrategy", (Object)this.dedupeStrategy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "loadType": {
                return Optional.ofNullable(clazz.cast(this.loadTypeAsString()));
            }
            case "dedupeRecords": {
                return Optional.ofNullable(clazz.cast(this.dedupeRecords()));
            }
            case "dedupeStrategy": {
                return Optional.ofNullable(clazz.cast(this.dedupeStrategy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("loadType", LOAD_TYPE_FIELD);
        map.put("dedupeRecords", DEDUPE_RECORDS_FIELD);
        map.put("dedupeStrategy", DEDUPE_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationFlowDatasetOptions, T> g) {
        return obj -> g.apply((DataIntegrationFlowDatasetOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String loadType;
        private Boolean dedupeRecords;
        private DataIntegrationFlowDedupeStrategy dedupeStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationFlowDatasetOptions model) {
            this.loadType(model.loadType);
            this.dedupeRecords(model.dedupeRecords);
            this.dedupeStrategy(model.dedupeStrategy);
        }

        public final String getLoadType() {
            return this.loadType;
        }

        public final void setLoadType(String loadType) {
            this.loadType = loadType;
        }

        @Override
        public final Builder loadType(String loadType) {
            this.loadType = loadType;
            return this;
        }

        @Override
        public final Builder loadType(DataIntegrationFlowLoadType loadType) {
            this.loadType(loadType == null ? null : loadType.toString());
            return this;
        }

        public final Boolean getDedupeRecords() {
            return this.dedupeRecords;
        }

        public final void setDedupeRecords(Boolean dedupeRecords) {
            this.dedupeRecords = dedupeRecords;
        }

        @Override
        public final Builder dedupeRecords(Boolean dedupeRecords) {
            this.dedupeRecords = dedupeRecords;
            return this;
        }

        public final DataIntegrationFlowDedupeStrategy.Builder getDedupeStrategy() {
            return this.dedupeStrategy != null ? this.dedupeStrategy.toBuilder() : null;
        }

        public final void setDedupeStrategy(DataIntegrationFlowDedupeStrategy.BuilderImpl dedupeStrategy) {
            this.dedupeStrategy = dedupeStrategy != null ? dedupeStrategy.build() : null;
        }

        @Override
        public final Builder dedupeStrategy(DataIntegrationFlowDedupeStrategy dedupeStrategy) {
            this.dedupeStrategy = dedupeStrategy;
            return this;
        }

        public DataIntegrationFlowDatasetOptions build() {
            return new DataIntegrationFlowDatasetOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataIntegrationFlowDatasetOptions> {
        public Builder loadType(String var1);

        public Builder loadType(DataIntegrationFlowLoadType var1);

        public Builder dedupeRecords(Boolean var1);

        public Builder dedupeStrategy(DataIntegrationFlowDedupeStrategy var1);

        default public Builder dedupeStrategy(Consumer<DataIntegrationFlowDedupeStrategy.Builder> dedupeStrategy) {
            return this.dedupeStrategy((DataIntegrationFlowDedupeStrategy)((DataIntegrationFlowDedupeStrategy.Builder)DataIntegrationFlowDedupeStrategy.builder().applyMutation(dedupeStrategy)).build());
        }
    }
}

