/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.supplychain.SupplyChainAsyncClient;
import software.amazon.awssdk.services.supplychain.internal.UserAgentUtils;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowExecution;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsResponse;

public class ListDataIntegrationFlowExecutionsPublisher
implements SdkPublisher<ListDataIntegrationFlowExecutionsResponse> {
    private final SupplyChainAsyncClient client;
    private final ListDataIntegrationFlowExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataIntegrationFlowExecutionsPublisher(SupplyChainAsyncClient client, ListDataIntegrationFlowExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataIntegrationFlowExecutionsPublisher(SupplyChainAsyncClient client, ListDataIntegrationFlowExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataIntegrationFlowExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataIntegrationFlowExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataIntegrationFlowExecution> flowExecutions() {
        Function<ListDataIntegrationFlowExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flowExecutions() != null) {
                return response.flowExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataIntegrationFlowExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataIntegrationFlowExecutionsResponseFetcher
    implements AsyncPageFetcher<ListDataIntegrationFlowExecutionsResponse> {
        private ListDataIntegrationFlowExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataIntegrationFlowExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataIntegrationFlowExecutionsResponse> nextPage(ListDataIntegrationFlowExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListDataIntegrationFlowExecutionsPublisher.this.client.listDataIntegrationFlowExecutions(ListDataIntegrationFlowExecutionsPublisher.this.firstRequest);
            }
            return ListDataIntegrationFlowExecutionsPublisher.this.client.listDataIntegrationFlowExecutions((ListDataIntegrationFlowExecutionsRequest)((Object)ListDataIntegrationFlowExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

