/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.supplychain.SupplyChainClient;
import software.amazon.awssdk.services.supplychain.internal.UserAgentUtils;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowExecution;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsResponse;

public class ListDataIntegrationFlowExecutionsIterable
implements SdkIterable<ListDataIntegrationFlowExecutionsResponse> {
    private final SupplyChainClient client;
    private final ListDataIntegrationFlowExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataIntegrationFlowExecutionsIterable(SupplyChainClient client, ListDataIntegrationFlowExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataIntegrationFlowExecutionsResponseFetcher();
    }

    public Iterator<ListDataIntegrationFlowExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataIntegrationFlowExecution> flowExecutions() {
        Function<ListDataIntegrationFlowExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flowExecutions() != null) {
                return response.flowExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataIntegrationFlowExecutionsResponseFetcher
    implements SyncPageFetcher<ListDataIntegrationFlowExecutionsResponse> {
        private ListDataIntegrationFlowExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataIntegrationFlowExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataIntegrationFlowExecutionsResponse nextPage(ListDataIntegrationFlowExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListDataIntegrationFlowExecutionsIterable.this.client.listDataIntegrationFlowExecutions(ListDataIntegrationFlowExecutionsIterable.this.firstRequest);
            }
            return ListDataIntegrationFlowExecutionsIterable.this.client.listDataIntegrationFlowExecutions((ListDataIntegrationFlowExecutionsRequest)((Object)ListDataIntegrationFlowExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

