/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowSQLTransformationConfiguration;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowTransformationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataIntegrationFlowTransformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataIntegrationFlowTransformation> {
    private static final SdkField<String> TRANSFORMATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transformationType").getter(DataIntegrationFlowTransformation.getter(DataIntegrationFlowTransformation::transformationTypeAsString)).setter(DataIntegrationFlowTransformation.setter(Builder::transformationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformationType").build()}).build();
    private static final SdkField<DataIntegrationFlowSQLTransformationConfiguration> SQL_TRANSFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sqlTransformation").getter(DataIntegrationFlowTransformation.getter(DataIntegrationFlowTransformation::sqlTransformation)).setter(DataIntegrationFlowTransformation.setter(Builder::sqlTransformation)).constructor(DataIntegrationFlowSQLTransformationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqlTransformation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORMATION_TYPE_FIELD, SQL_TRANSFORMATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataIntegrationFlowTransformation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String transformationType;
    private final DataIntegrationFlowSQLTransformationConfiguration sqlTransformation;

    private DataIntegrationFlowTransformation(BuilderImpl builder) {
        this.transformationType = builder.transformationType;
        this.sqlTransformation = builder.sqlTransformation;
    }

    public final DataIntegrationFlowTransformationType transformationType() {
        return DataIntegrationFlowTransformationType.fromValue(this.transformationType);
    }

    public final String transformationTypeAsString() {
        return this.transformationType;
    }

    public final DataIntegrationFlowSQLTransformationConfiguration sqlTransformation() {
        return this.sqlTransformation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transformationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlTransformation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationFlowTransformation)) {
            return false;
        }
        DataIntegrationFlowTransformation other = (DataIntegrationFlowTransformation)obj;
        return Objects.equals(this.transformationTypeAsString(), other.transformationTypeAsString()) && Objects.equals(this.sqlTransformation(), other.sqlTransformation());
    }

    public final String toString() {
        return ToString.builder((String)"DataIntegrationFlowTransformation").add("TransformationType", (Object)this.transformationTypeAsString()).add("SqlTransformation", (Object)this.sqlTransformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "transformationType": {
                return Optional.ofNullable(clazz.cast(this.transformationTypeAsString()));
            }
            case "sqlTransformation": {
                return Optional.ofNullable(clazz.cast(this.sqlTransformation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("transformationType", TRANSFORMATION_TYPE_FIELD);
        map.put("sqlTransformation", SQL_TRANSFORMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationFlowTransformation, T> g) {
        return obj -> g.apply((DataIntegrationFlowTransformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transformationType;
        private DataIntegrationFlowSQLTransformationConfiguration sqlTransformation;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationFlowTransformation model) {
            this.transformationType(model.transformationType);
            this.sqlTransformation(model.sqlTransformation);
        }

        public final String getTransformationType() {
            return this.transformationType;
        }

        public final void setTransformationType(String transformationType) {
            this.transformationType = transformationType;
        }

        @Override
        public final Builder transformationType(String transformationType) {
            this.transformationType = transformationType;
            return this;
        }

        @Override
        public final Builder transformationType(DataIntegrationFlowTransformationType transformationType) {
            this.transformationType(transformationType == null ? null : transformationType.toString());
            return this;
        }

        public final DataIntegrationFlowSQLTransformationConfiguration.Builder getSqlTransformation() {
            return this.sqlTransformation != null ? this.sqlTransformation.toBuilder() : null;
        }

        public final void setSqlTransformation(DataIntegrationFlowSQLTransformationConfiguration.BuilderImpl sqlTransformation) {
            this.sqlTransformation = sqlTransformation != null ? sqlTransformation.build() : null;
        }

        @Override
        public final Builder sqlTransformation(DataIntegrationFlowSQLTransformationConfiguration sqlTransformation) {
            this.sqlTransformation = sqlTransformation;
            return this;
        }

        public DataIntegrationFlowTransformation build() {
            return new DataIntegrationFlowTransformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataIntegrationFlowTransformation> {
        public Builder transformationType(String var1);

        public Builder transformationType(DataIntegrationFlowTransformationType var1);

        public Builder sqlTransformation(DataIntegrationFlowSQLTransformationConfiguration var1);

        default public Builder sqlTransformation(Consumer<DataIntegrationFlowSQLTransformationConfiguration.Builder> sqlTransformation) {
            return this.sqlTransformation((DataIntegrationFlowSQLTransformationConfiguration)((DataIntegrationFlowSQLTransformationConfiguration.Builder)DataIntegrationFlowSQLTransformationConfiguration.builder().applyMutation(sqlTransformation)).build());
        }
    }
}

