/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataIntegrationFlowSourceType {
    S3("S3"),
    DATASET("DATASET"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataIntegrationFlowSourceType> VALUE_MAP;
    private final String value;

    private DataIntegrationFlowSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataIntegrationFlowSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataIntegrationFlowSourceType> knownValues() {
        EnumSet<DataIntegrationFlowSourceType> knownValues = EnumSet.allOf(DataIntegrationFlowSourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataIntegrationFlowSourceType.class, DataIntegrationFlowSourceType::toString);
    }
}

