/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the provided context. This includes the signed and encrypted trusted context assertion and
 * the context provider ARN from which the trusted context assertion was generated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvidedContext implements SdkPojo, Serializable, ToCopyableBuilder<ProvidedContext.Builder, ProvidedContext> {
    private static final SdkField<String> PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderArn").getter(getter(ProvidedContext::providerArn)).setter(setter(Builder::providerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderArn").build()).build();

    private static final SdkField<String> CONTEXT_ASSERTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContextAssertion").getter(getter(ProvidedContext::contextAssertion))
            .setter(setter(Builder::contextAssertion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextAssertion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_ARN_FIELD,
            CONTEXT_ASSERTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ProviderArn", PROVIDER_ARN_FIELD);
                    put("ContextAssertion", CONTEXT_ASSERTION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String providerArn;

    private final String contextAssertion;

    private ProvidedContext(BuilderImpl builder) {
        this.providerArn = builder.providerArn;
        this.contextAssertion = builder.contextAssertion;
    }

    /**
     * <p>
     * The context provider ARN from which the trusted context assertion was generated.
     * </p>
     * 
     * @return The context provider ARN from which the trusted context assertion was generated.
     */
    public final String providerArn() {
        return providerArn;
    }

    /**
     * <p>
     * The signed and encrypted trusted context assertion generated by the context provider. The trusted context
     * assertion is signed and encrypted by Amazon Web Services STS.
     * </p>
     * 
     * @return The signed and encrypted trusted context assertion generated by the context provider. The trusted context
     *         assertion is signed and encrypted by Amazon Web Services STS.
     */
    public final String contextAssertion() {
        return contextAssertion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(providerArn());
        hashCode = 31 * hashCode + Objects.hashCode(contextAssertion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvidedContext)) {
            return false;
        }
        ProvidedContext other = (ProvidedContext) obj;
        return Objects.equals(providerArn(), other.providerArn()) && Objects.equals(contextAssertion(), other.contextAssertion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvidedContext").add("ProviderArn", providerArn()).add("ContextAssertion", contextAssertion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProviderArn":
            return Optional.ofNullable(clazz.cast(providerArn()));
        case "ContextAssertion":
            return Optional.ofNullable(clazz.cast(contextAssertion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProvidedContext, T> g) {
        return obj -> g.apply((ProvidedContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvidedContext> {
        /**
         * <p>
         * The context provider ARN from which the trusted context assertion was generated.
         * </p>
         * 
         * @param providerArn
         *        The context provider ARN from which the trusted context assertion was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerArn(String providerArn);

        /**
         * <p>
         * The signed and encrypted trusted context assertion generated by the context provider. The trusted context
         * assertion is signed and encrypted by Amazon Web Services STS.
         * </p>
         * 
         * @param contextAssertion
         *        The signed and encrypted trusted context assertion generated by the context provider. The trusted
         *        context assertion is signed and encrypted by Amazon Web Services STS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextAssertion(String contextAssertion);
    }

    static final class BuilderImpl implements Builder {
        private String providerArn;

        private String contextAssertion;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvidedContext model) {
            providerArn(model.providerArn);
            contextAssertion(model.contextAssertion);
        }

        public final String getProviderArn() {
            return providerArn;
        }

        public final void setProviderArn(String providerArn) {
            this.providerArn = providerArn;
        }

        @Override
        public final Builder providerArn(String providerArn) {
            this.providerArn = providerArn;
            return this;
        }

        public final String getContextAssertion() {
            return contextAssertion;
        }

        public final void setContextAssertion(String contextAssertion) {
            this.contextAssertion = contextAssertion;
        }

        @Override
        public final Builder contextAssertion(String contextAssertion) {
            this.contextAssertion = contextAssertion;
            return this;
        }

        @Override
        public ProvidedContext build() {
            return new ProvidedContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
