/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayClient;
import software.amazon.awssdk.services.storagegateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest;
import software.amazon.awssdk.services.storagegateway.model.ListTapePoolsResponse;
import software.amazon.awssdk.services.storagegateway.model.PoolInfo;

public class ListTapePoolsIterable
implements SdkIterable<ListTapePoolsResponse> {
    private final StorageGatewayClient client;
    private final ListTapePoolsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTapePoolsIterable(StorageGatewayClient client, ListTapePoolsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTapePoolsResponseFetcher();
    }

    public Iterator<ListTapePoolsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PoolInfo> poolInfos() {
        Function<ListTapePoolsResponse, Iterator> getIterator = response -> {
            if (response != null && response.poolInfos() != null) {
                return response.poolInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTapePoolsResponseFetcher
    implements SyncPageFetcher<ListTapePoolsResponse> {
        private ListTapePoolsResponseFetcher() {
        }

        public boolean hasNextPage(ListTapePoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public ListTapePoolsResponse nextPage(ListTapePoolsResponse previousPage) {
            if (previousPage == null) {
                return ListTapePoolsIterable.this.client.listTapePools(ListTapePoolsIterable.this.firstRequest);
            }
            return ListTapePoolsIterable.this.client.listTapePools((ListTapePoolsRequest)((Object)ListTapePoolsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

