/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ErrorCode {
    ACTIVATION_KEY_EXPIRED("ActivationKeyExpired"),
    ACTIVATION_KEY_INVALID("ActivationKeyInvalid"),
    ACTIVATION_KEY_NOT_FOUND("ActivationKeyNotFound"),
    GATEWAY_INTERNAL_ERROR("GatewayInternalError"),
    GATEWAY_NOT_CONNECTED("GatewayNotConnected"),
    GATEWAY_NOT_FOUND("GatewayNotFound"),
    GATEWAY_PROXY_NETWORK_CONNECTION_BUSY("GatewayProxyNetworkConnectionBusy"),
    AUTHENTICATION_FAILURE("AuthenticationFailure"),
    BANDWIDTH_THROTTLE_SCHEDULE_NOT_FOUND("BandwidthThrottleScheduleNotFound"),
    BLOCKED("Blocked"),
    CANNOT_EXPORT_SNAPSHOT("CannotExportSnapshot"),
    CHAP_CREDENTIAL_NOT_FOUND("ChapCredentialNotFound"),
    DISK_ALREADY_ALLOCATED("DiskAlreadyAllocated"),
    DISK_DOES_NOT_EXIST("DiskDoesNotExist"),
    DISK_SIZE_GREATER_THAN_VOLUME_MAX_SIZE("DiskSizeGreaterThanVolumeMaxSize"),
    DISK_SIZE_LESS_THAN_VOLUME_SIZE("DiskSizeLessThanVolumeSize"),
    DISK_SIZE_NOT_GIG_ALIGNED("DiskSizeNotGigAligned"),
    DUPLICATE_CERTIFICATE_INFO("DuplicateCertificateInfo"),
    DUPLICATE_SCHEDULE("DuplicateSchedule"),
    ENDPOINT_NOT_FOUND("EndpointNotFound"),
    IAM_NOT_SUPPORTED("IAMNotSupported"),
    INITIATOR_INVALID("InitiatorInvalid"),
    INITIATOR_NOT_FOUND("InitiatorNotFound"),
    INTERNAL_ERROR("InternalError"),
    INVALID_GATEWAY("InvalidGateway"),
    INVALID_ENDPOINT("InvalidEndpoint"),
    INVALID_PARAMETERS("InvalidParameters"),
    INVALID_SCHEDULE("InvalidSchedule"),
    LOCAL_STORAGE_LIMIT_EXCEEDED("LocalStorageLimitExceeded"),
    LUN_ALREADY_ALLOCATED("LunAlreadyAllocated "),
    LUN_INVALID("LunInvalid"),
    JOIN_DOMAIN_IN_PROGRESS("JoinDomainInProgress"),
    MAXIMUM_CONTENT_LENGTH_EXCEEDED("MaximumContentLengthExceeded"),
    MAXIMUM_TAPE_CARTRIDGE_COUNT_EXCEEDED("MaximumTapeCartridgeCountExceeded"),
    MAXIMUM_VOLUME_COUNT_EXCEEDED("MaximumVolumeCountExceeded"),
    NETWORK_CONFIGURATION_CHANGED("NetworkConfigurationChanged"),
    NO_DISKS_AVAILABLE("NoDisksAvailable"),
    NOT_IMPLEMENTED("NotImplemented"),
    NOT_SUPPORTED("NotSupported"),
    OPERATION_ABORTED("OperationAborted"),
    OUTDATED_GATEWAY("OutdatedGateway"),
    PARAMETERS_NOT_IMPLEMENTED("ParametersNotImplemented"),
    REGION_INVALID("RegionInvalid"),
    REQUEST_TIMEOUT("RequestTimeout"),
    SERVICE_UNAVAILABLE("ServiceUnavailable"),
    SNAPSHOT_DELETED("SnapshotDeleted"),
    SNAPSHOT_ID_INVALID("SnapshotIdInvalid"),
    SNAPSHOT_IN_PROGRESS("SnapshotInProgress"),
    SNAPSHOT_NOT_FOUND("SnapshotNotFound"),
    SNAPSHOT_SCHEDULE_NOT_FOUND("SnapshotScheduleNotFound"),
    STAGING_AREA_FULL("StagingAreaFull"),
    STORAGE_FAILURE("StorageFailure"),
    TAPE_CARTRIDGE_NOT_FOUND("TapeCartridgeNotFound"),
    TARGET_ALREADY_EXISTS("TargetAlreadyExists"),
    TARGET_INVALID("TargetInvalid"),
    TARGET_NOT_FOUND("TargetNotFound"),
    UNAUTHORIZED_OPERATION("UnauthorizedOperation"),
    VOLUME_ALREADY_EXISTS("VolumeAlreadyExists"),
    VOLUME_ID_INVALID("VolumeIdInvalid"),
    VOLUME_IN_USE("VolumeInUse"),
    VOLUME_NOT_FOUND("VolumeNotFound"),
    VOLUME_NOT_READY("VolumeNotReady"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ErrorCode> VALUE_MAP;
    private final String value;

    private ErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ErrorCode> knownValues() {
        EnumSet<ErrorCode> knownValues = EnumSet.allOf(ErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ErrorCode.class, ErrorCode::toString);
    }
}

