/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.SoftwareUpdatePreferences;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMaintenanceStartTimeResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeMaintenanceStartTimeResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(DescribeMaintenanceStartTimeResponse.getter(DescribeMaintenanceStartTimeResponse::gatewayARN)).setter(DescribeMaintenanceStartTimeResponse.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<Integer> HOUR_OF_DAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HourOfDay").getter(DescribeMaintenanceStartTimeResponse.getter(DescribeMaintenanceStartTimeResponse::hourOfDay)).setter(DescribeMaintenanceStartTimeResponse.setter(Builder::hourOfDay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourOfDay").build()}).build();
    private static final SdkField<Integer> MINUTE_OF_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinuteOfHour").getter(DescribeMaintenanceStartTimeResponse.getter(DescribeMaintenanceStartTimeResponse::minuteOfHour)).setter(DescribeMaintenanceStartTimeResponse.setter(Builder::minuteOfHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinuteOfHour").build()}).build();
    private static final SdkField<Integer> DAY_OF_WEEK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DayOfWeek").getter(DescribeMaintenanceStartTimeResponse.getter(DescribeMaintenanceStartTimeResponse::dayOfWeek)).setter(DescribeMaintenanceStartTimeResponse.setter(Builder::dayOfWeek)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfWeek").build()}).build();
    private static final SdkField<Integer> DAY_OF_MONTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DayOfMonth").getter(DescribeMaintenanceStartTimeResponse.getter(DescribeMaintenanceStartTimeResponse::dayOfMonth)).setter(DescribeMaintenanceStartTimeResponse.setter(Builder::dayOfMonth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfMonth").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timezone").getter(DescribeMaintenanceStartTimeResponse.getter(DescribeMaintenanceStartTimeResponse::timezone)).setter(DescribeMaintenanceStartTimeResponse.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build();
    private static final SdkField<SoftwareUpdatePreferences> SOFTWARE_UPDATE_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SoftwareUpdatePreferences").getter(DescribeMaintenanceStartTimeResponse.getter(DescribeMaintenanceStartTimeResponse::softwareUpdatePreferences)).setter(DescribeMaintenanceStartTimeResponse.setter(Builder::softwareUpdatePreferences)).constructor(SoftwareUpdatePreferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareUpdatePreferences").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, HOUR_OF_DAY_FIELD, MINUTE_OF_HOUR_FIELD, DAY_OF_WEEK_FIELD, DAY_OF_MONTH_FIELD, TIMEZONE_FIELD, SOFTWARE_UPDATE_PREFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeMaintenanceStartTimeResponse.memberNameToFieldInitializer();
    private final String gatewayARN;
    private final Integer hourOfDay;
    private final Integer minuteOfHour;
    private final Integer dayOfWeek;
    private final Integer dayOfMonth;
    private final String timezone;
    private final SoftwareUpdatePreferences softwareUpdatePreferences;

    private DescribeMaintenanceStartTimeResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.hourOfDay = builder.hourOfDay;
        this.minuteOfHour = builder.minuteOfHour;
        this.dayOfWeek = builder.dayOfWeek;
        this.dayOfMonth = builder.dayOfMonth;
        this.timezone = builder.timezone;
        this.softwareUpdatePreferences = builder.softwareUpdatePreferences;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final Integer hourOfDay() {
        return this.hourOfDay;
    }

    public final Integer minuteOfHour() {
        return this.minuteOfHour;
    }

    public final Integer dayOfWeek() {
        return this.dayOfWeek;
    }

    public final Integer dayOfMonth() {
        return this.dayOfMonth;
    }

    public final String timezone() {
        return this.timezone;
    }

    public final SoftwareUpdatePreferences softwareUpdatePreferences() {
        return this.softwareUpdatePreferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hourOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(this.minuteOfHour());
        hashCode = 31 * hashCode + Objects.hashCode(this.dayOfWeek());
        hashCode = 31 * hashCode + Objects.hashCode(this.dayOfMonth());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareUpdatePreferences());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceStartTimeResponse)) {
            return false;
        }
        DescribeMaintenanceStartTimeResponse other = (DescribeMaintenanceStartTimeResponse)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.hourOfDay(), other.hourOfDay()) && Objects.equals(this.minuteOfHour(), other.minuteOfHour()) && Objects.equals(this.dayOfWeek(), other.dayOfWeek()) && Objects.equals(this.dayOfMonth(), other.dayOfMonth()) && Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.softwareUpdatePreferences(), other.softwareUpdatePreferences());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMaintenanceStartTimeResponse").add("GatewayARN", (Object)this.gatewayARN()).add("HourOfDay", (Object)this.hourOfDay()).add("MinuteOfHour", (Object)this.minuteOfHour()).add("DayOfWeek", (Object)this.dayOfWeek()).add("DayOfMonth", (Object)this.dayOfMonth()).add("Timezone", (Object)this.timezone()).add("SoftwareUpdatePreferences", (Object)this.softwareUpdatePreferences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "HourOfDay": {
                return Optional.ofNullable(clazz.cast(this.hourOfDay()));
            }
            case "MinuteOfHour": {
                return Optional.ofNullable(clazz.cast(this.minuteOfHour()));
            }
            case "DayOfWeek": {
                return Optional.ofNullable(clazz.cast(this.dayOfWeek()));
            }
            case "DayOfMonth": {
                return Optional.ofNullable(clazz.cast(this.dayOfMonth()));
            }
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "SoftwareUpdatePreferences": {
                return Optional.ofNullable(clazz.cast(this.softwareUpdatePreferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        map.put("HourOfDay", HOUR_OF_DAY_FIELD);
        map.put("MinuteOfHour", MINUTE_OF_HOUR_FIELD);
        map.put("DayOfWeek", DAY_OF_WEEK_FIELD);
        map.put("DayOfMonth", DAY_OF_MONTH_FIELD);
        map.put("Timezone", TIMEZONE_FIELD);
        map.put("SoftwareUpdatePreferences", SOFTWARE_UPDATE_PREFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMaintenanceStartTimeResponse, T> g) {
        return obj -> g.apply((DescribeMaintenanceStartTimeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private Integer hourOfDay;
        private Integer minuteOfHour;
        private Integer dayOfWeek;
        private Integer dayOfMonth;
        private String timezone;
        private SoftwareUpdatePreferences softwareUpdatePreferences;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceStartTimeResponse model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.hourOfDay(model.hourOfDay);
            this.minuteOfHour(model.minuteOfHour);
            this.dayOfWeek(model.dayOfWeek);
            this.dayOfMonth(model.dayOfMonth);
            this.timezone(model.timezone);
            this.softwareUpdatePreferences(model.softwareUpdatePreferences);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final Integer getHourOfDay() {
            return this.hourOfDay;
        }

        public final void setHourOfDay(Integer hourOfDay) {
            this.hourOfDay = hourOfDay;
        }

        @Override
        public final Builder hourOfDay(Integer hourOfDay) {
            this.hourOfDay = hourOfDay;
            return this;
        }

        public final Integer getMinuteOfHour() {
            return this.minuteOfHour;
        }

        public final void setMinuteOfHour(Integer minuteOfHour) {
            this.minuteOfHour = minuteOfHour;
        }

        @Override
        public final Builder minuteOfHour(Integer minuteOfHour) {
            this.minuteOfHour = minuteOfHour;
            return this;
        }

        public final Integer getDayOfWeek() {
            return this.dayOfWeek;
        }

        public final void setDayOfWeek(Integer dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(Integer dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        public final Integer getDayOfMonth() {
            return this.dayOfMonth;
        }

        public final void setDayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
        }

        @Override
        public final Builder dayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final SoftwareUpdatePreferences.Builder getSoftwareUpdatePreferences() {
            return this.softwareUpdatePreferences != null ? this.softwareUpdatePreferences.toBuilder() : null;
        }

        public final void setSoftwareUpdatePreferences(SoftwareUpdatePreferences.BuilderImpl softwareUpdatePreferences) {
            this.softwareUpdatePreferences = softwareUpdatePreferences != null ? softwareUpdatePreferences.build() : null;
        }

        @Override
        public final Builder softwareUpdatePreferences(SoftwareUpdatePreferences softwareUpdatePreferences) {
            this.softwareUpdatePreferences = softwareUpdatePreferences;
            return this;
        }

        @Override
        public DescribeMaintenanceStartTimeResponse build() {
            return new DescribeMaintenanceStartTimeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMaintenanceStartTimeResponse> {
        public Builder gatewayARN(String var1);

        public Builder hourOfDay(Integer var1);

        public Builder minuteOfHour(Integer var1);

        public Builder dayOfWeek(Integer var1);

        public Builder dayOfMonth(Integer var1);

        public Builder timezone(String var1);

        public Builder softwareUpdatePreferences(SoftwareUpdatePreferences var1);

        default public Builder softwareUpdatePreferences(Consumer<SoftwareUpdatePreferences.Builder> softwareUpdatePreferences) {
            return this.softwareUpdatePreferences((SoftwareUpdatePreferences)((SoftwareUpdatePreferences.Builder)SoftwareUpdatePreferences.builder().applyMutation(softwareUpdatePreferences)).build());
        }
    }
}

