/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.InitiatorsCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVolumeInitiatorsResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, ListVolumeInitiatorsResponse> {
    private static final SdkField<List<String>> INITIATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Initiators").getter(ListVolumeInitiatorsResponse.getter(ListVolumeInitiatorsResponse::initiators)).setter(ListVolumeInitiatorsResponse.setter(Builder::initiators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Initiators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIATORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListVolumeInitiatorsResponse.memberNameToFieldInitializer();
    private final List<String> initiators;

    private ListVolumeInitiatorsResponse(BuilderImpl builder) {
        super(builder);
        this.initiators = builder.initiators;
    }

    public final boolean hasInitiators() {
        return this.initiators != null && !(this.initiators instanceof SdkAutoConstructList);
    }

    public final List<String> initiators() {
        return this.initiators;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInitiators() ? this.initiators() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVolumeInitiatorsResponse)) {
            return false;
        }
        ListVolumeInitiatorsResponse other = (ListVolumeInitiatorsResponse)((Object)obj);
        return this.hasInitiators() == other.hasInitiators() && Objects.equals(this.initiators(), other.initiators());
    }

    public final String toString() {
        return ToString.builder((String)"ListVolumeInitiatorsResponse").add("Initiators", this.hasInitiators() ? this.initiators() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Initiators": {
                return Optional.ofNullable(clazz.cast(this.initiators()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("Initiators", INITIATORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVolumeInitiatorsResponse, T> g) {
        return obj -> g.apply((ListVolumeInitiatorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private List<String> initiators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVolumeInitiatorsResponse model) {
            super(model);
            this.initiators(model.initiators);
        }

        public final Collection<String> getInitiators() {
            if (this.initiators instanceof SdkAutoConstructList) {
                return null;
            }
            return this.initiators;
        }

        public final void setInitiators(Collection<String> initiators) {
            this.initiators = InitiatorsCopier.copy(initiators);
        }

        @Override
        public final Builder initiators(Collection<String> initiators) {
            this.initiators = InitiatorsCopier.copy(initiators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initiators(String ... initiators) {
            this.initiators(Arrays.asList(initiators));
            return this;
        }

        @Override
        public ListVolumeInitiatorsResponse build() {
            return new ListVolumeInitiatorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVolumeInitiatorsResponse> {
        public Builder initiators(Collection<String> var1);

        public Builder initiators(String ... var1);
    }
}

