/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssooidc.model.SsoOidcResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDeviceAuthorizationResponse
extends SsoOidcResponse
implements ToCopyableBuilder<Builder, StartDeviceAuthorizationResponse> {
    private static final SdkField<String> DEVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceCode").getter(StartDeviceAuthorizationResponse.getter(StartDeviceAuthorizationResponse::deviceCode)).setter(StartDeviceAuthorizationResponse.setter(Builder::deviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceCode").build()}).build();
    private static final SdkField<String> USER_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userCode").getter(StartDeviceAuthorizationResponse.getter(StartDeviceAuthorizationResponse::userCode)).setter(StartDeviceAuthorizationResponse.setter(Builder::userCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userCode").build()}).build();
    private static final SdkField<String> VERIFICATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("verificationUri").getter(StartDeviceAuthorizationResponse.getter(StartDeviceAuthorizationResponse::verificationUri)).setter(StartDeviceAuthorizationResponse.setter(Builder::verificationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verificationUri").build()}).build();
    private static final SdkField<String> VERIFICATION_URI_COMPLETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("verificationUriComplete").getter(StartDeviceAuthorizationResponse.getter(StartDeviceAuthorizationResponse::verificationUriComplete)).setter(StartDeviceAuthorizationResponse.setter(Builder::verificationUriComplete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verificationUriComplete").build()}).build();
    private static final SdkField<Integer> EXPIRES_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("expiresIn").getter(StartDeviceAuthorizationResponse.getter(StartDeviceAuthorizationResponse::expiresIn)).setter(StartDeviceAuthorizationResponse.setter(Builder::expiresIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresIn").build()}).build();
    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("interval").getter(StartDeviceAuthorizationResponse.getter(StartDeviceAuthorizationResponse::interval)).setter(StartDeviceAuthorizationResponse.setter(Builder::interval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interval").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_CODE_FIELD, USER_CODE_FIELD, VERIFICATION_URI_FIELD, VERIFICATION_URI_COMPLETE_FIELD, EXPIRES_IN_FIELD, INTERVAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartDeviceAuthorizationResponse.memberNameToFieldInitializer();
    private final String deviceCode;
    private final String userCode;
    private final String verificationUri;
    private final String verificationUriComplete;
    private final Integer expiresIn;
    private final Integer interval;

    private StartDeviceAuthorizationResponse(BuilderImpl builder) {
        super(builder);
        this.deviceCode = builder.deviceCode;
        this.userCode = builder.userCode;
        this.verificationUri = builder.verificationUri;
        this.verificationUriComplete = builder.verificationUriComplete;
        this.expiresIn = builder.expiresIn;
        this.interval = builder.interval;
    }

    public final String deviceCode() {
        return this.deviceCode;
    }

    public final String userCode() {
        return this.userCode;
    }

    public final String verificationUri() {
        return this.verificationUri;
    }

    public final String verificationUriComplete() {
        return this.verificationUriComplete;
    }

    public final Integer expiresIn() {
        return this.expiresIn;
    }

    public final Integer interval() {
        return this.interval;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.userCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationUriComplete());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.interval());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDeviceAuthorizationResponse)) {
            return false;
        }
        StartDeviceAuthorizationResponse other = (StartDeviceAuthorizationResponse)((Object)obj);
        return Objects.equals(this.deviceCode(), other.deviceCode()) && Objects.equals(this.userCode(), other.userCode()) && Objects.equals(this.verificationUri(), other.verificationUri()) && Objects.equals(this.verificationUriComplete(), other.verificationUriComplete()) && Objects.equals(this.expiresIn(), other.expiresIn()) && Objects.equals(this.interval(), other.interval());
    }

    public final String toString() {
        return ToString.builder((String)"StartDeviceAuthorizationResponse").add("DeviceCode", (Object)this.deviceCode()).add("UserCode", (Object)this.userCode()).add("VerificationUri", (Object)this.verificationUri()).add("VerificationUriComplete", (Object)this.verificationUriComplete()).add("ExpiresIn", (Object)this.expiresIn()).add("Interval", (Object)this.interval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deviceCode": {
                return Optional.ofNullable(clazz.cast(this.deviceCode()));
            }
            case "userCode": {
                return Optional.ofNullable(clazz.cast(this.userCode()));
            }
            case "verificationUri": {
                return Optional.ofNullable(clazz.cast(this.verificationUri()));
            }
            case "verificationUriComplete": {
                return Optional.ofNullable(clazz.cast(this.verificationUriComplete()));
            }
            case "expiresIn": {
                return Optional.ofNullable(clazz.cast(this.expiresIn()));
            }
            case "interval": {
                return Optional.ofNullable(clazz.cast(this.interval()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deviceCode", DEVICE_CODE_FIELD);
        map.put("userCode", USER_CODE_FIELD);
        map.put("verificationUri", VERIFICATION_URI_FIELD);
        map.put("verificationUriComplete", VERIFICATION_URI_COMPLETE_FIELD);
        map.put("expiresIn", EXPIRES_IN_FIELD);
        map.put("interval", INTERVAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDeviceAuthorizationResponse, T> g) {
        return obj -> g.apply((StartDeviceAuthorizationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoOidcResponse.BuilderImpl
    implements Builder {
        private String deviceCode;
        private String userCode;
        private String verificationUri;
        private String verificationUriComplete;
        private Integer expiresIn;
        private Integer interval;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDeviceAuthorizationResponse model) {
            super(model);
            this.deviceCode(model.deviceCode);
            this.userCode(model.userCode);
            this.verificationUri(model.verificationUri);
            this.verificationUriComplete(model.verificationUriComplete);
            this.expiresIn(model.expiresIn);
            this.interval(model.interval);
        }

        public final String getDeviceCode() {
            return this.deviceCode;
        }

        public final void setDeviceCode(String deviceCode) {
            this.deviceCode = deviceCode;
        }

        @Override
        public final Builder deviceCode(String deviceCode) {
            this.deviceCode = deviceCode;
            return this;
        }

        public final String getUserCode() {
            return this.userCode;
        }

        public final void setUserCode(String userCode) {
            this.userCode = userCode;
        }

        @Override
        public final Builder userCode(String userCode) {
            this.userCode = userCode;
            return this;
        }

        public final String getVerificationUri() {
            return this.verificationUri;
        }

        public final void setVerificationUri(String verificationUri) {
            this.verificationUri = verificationUri;
        }

        @Override
        public final Builder verificationUri(String verificationUri) {
            this.verificationUri = verificationUri;
            return this;
        }

        public final String getVerificationUriComplete() {
            return this.verificationUriComplete;
        }

        public final void setVerificationUriComplete(String verificationUriComplete) {
            this.verificationUriComplete = verificationUriComplete;
        }

        @Override
        public final Builder verificationUriComplete(String verificationUriComplete) {
            this.verificationUriComplete = verificationUriComplete;
            return this;
        }

        public final Integer getExpiresIn() {
            return this.expiresIn;
        }

        public final void setExpiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
        }

        @Override
        public final Builder expiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public final Integer getInterval() {
            return this.interval;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        @Override
        public StartDeviceAuthorizationResponse build() {
            return new StartDeviceAuthorizationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsoOidcResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDeviceAuthorizationResponse> {
        public Builder deviceCode(String var1);

        public Builder userCode(String var1);

        public Builder verificationUri(String var1);

        public Builder verificationUriComplete(String var1);

        public Builder expiresIn(Integer var1);

        public Builder interval(Integer var1);
    }
}

