/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.internal.token.TokenManager;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.services.ssooidc.internal.SsoOidcToken;
import software.amazon.awssdk.thirdparty.jackson.core.JsonGenerator;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.UserHomeDirectoryUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class OnDiskTokenManager
implements TokenManager<SsoOidcToken> {
    private static final Path DEFAULT_TOKEN_LOCATION = Paths.get(UserHomeDirectoryUtils.userHomeDirectory(), ".aws", "sso", "cache");
    private final JsonNodeParser jsonParser = JsonNodeParser.builder().removeErrorLocations(true).build();
    private final String sessionName;
    private final Path tokenLocation;

    private OnDiskTokenManager(Path cacheLocation, String sessionName) {
        Validate.notNull((Object)cacheLocation, (String)"cacheLocation must not be null", (Object[])new Object[0]);
        this.sessionName = (String)Validate.notNull((Object)sessionName, (String)"sessionName must not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)sessionName, (String)"sessionName must not be blank", (Object[])new Object[0]);
        String cacheKey = OnDiskTokenManager.deriveCacheKey(sessionName);
        this.tokenLocation = cacheLocation.resolve(cacheKey + ".json");
    }

    public Optional<SsoOidcToken> loadToken() {
        Optional<SsoOidcToken> optional;
        block9: {
            if (!Files.exists(this.tokenLocation, new LinkOption[0])) {
                return Optional.empty();
            }
            InputStream cachedTokenStream = Files.newInputStream(this.tokenLocation, new OpenOption[0]);
            try {
                String content = IoUtils.toUtf8String((InputStream)cachedTokenStream);
                optional = Optional.of(this.unmarshalToken(content));
                if (cachedTokenStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (cachedTokenStream != null) {
                        try {
                            cachedTokenStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw SdkClientException.create((String)("Failed to load cached token at " + this.tokenLocation), (Throwable)e);
                }
            }
            cachedTokenStream.close();
        }
        return optional;
    }

    public void storeToken(SsoOidcToken token) {
        try (OutputStream os = Files.newOutputStream(this.tokenLocation, new OpenOption[0]);){
            os.write(this.marshalToken(token));
        }
        catch (IOException e) {
            throw SdkClientException.create((String)("Unable to write token to location " + this.tokenLocation), (Throwable)e);
        }
    }

    public void close() {
    }

    public static OnDiskTokenManager create(Path cacheLocation, String sessionName) {
        return new OnDiskTokenManager(cacheLocation, sessionName);
    }

    public static OnDiskTokenManager create(String sessionName) {
        return OnDiskTokenManager.create(DEFAULT_TOKEN_LOCATION, sessionName);
    }

    private SsoOidcToken unmarshalToken(String contents) {
        JsonNode node = this.jsonParser.parse(contents);
        SsoOidcToken.Builder tokenBuilder = SsoOidcToken.builder();
        JsonNode accessToken = (JsonNode)node.field("accessToken").orElseThrow(() -> SdkClientException.create((String)"required member 'accessToken' not found"));
        tokenBuilder.accessToken(accessToken.text());
        JsonNode expiresAt = (JsonNode)node.field("expiresAt").orElseThrow(() -> SdkClientException.create((String)"required member 'expiresAt' not found"));
        tokenBuilder.expiresAt(Instant.parse(expiresAt.text()));
        node.field("refreshToken").map(JsonNode::text).ifPresent(tokenBuilder::refreshToken);
        node.field("clientId").map(JsonNode::text).ifPresent(tokenBuilder::clientId);
        node.field("clientSecret").map(JsonNode::text).ifPresent(tokenBuilder::clientSecret);
        node.field("registrationExpiresAt").map(JsonNode::text).map(Instant::parse).ifPresent(tokenBuilder::registrationExpiresAt);
        node.field("region").map(JsonNode::text).ifPresent(tokenBuilder::region);
        node.field("startUrl").map(JsonNode::text).ifPresent(tokenBuilder::startUrl);
        tokenBuilder.providerName("SsoOidcTokenProvider");
        return tokenBuilder.build();
    }

    private byte[] marshalToken(SsoOidcToken token) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonGenerator generator = null;
        try {
            generator = JsonNodeParser.DEFAULT_JSON_FACTORY.createGenerator((OutputStream)baos);
            generator.writeStartObject();
            generator.writeStringField("accessToken", token.token());
            generator.writeStringField("expiresAt", DateTimeFormatter.ISO_INSTANT.format(token.expirationTime().get()));
            if (token.refreshToken() != null) {
                generator.writeStringField("refreshToken", token.refreshToken());
            }
            if (token.clientId() != null) {
                generator.writeStringField("clientId", token.clientId());
            }
            if (token.clientSecret() != null) {
                generator.writeStringField("clientSecret", token.clientSecret());
            }
            if (token.registrationExpiresAt() != null) {
                generator.writeStringField("registrationExpiresAt", DateTimeFormatter.ISO_INSTANT.format(token.registrationExpiresAt()));
            }
            if (token.region() != null) {
                generator.writeStringField("region", token.region());
            }
            if (token.startUrl() != null) {
                generator.writeStringField("startUrl", token.startUrl());
            }
            generator.writeEndObject();
            generator.close();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw SdkClientException.create((String)"Unable to marshal token to JSON", (Throwable)e);
        }
        finally {
            if (generator != null) {
                IoUtils.closeQuietly((AutoCloseable)generator, null);
            }
        }
    }

    private static String deriveCacheKey(String sessionName) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("sha1");
            sha1.update(sessionName.getBytes(StandardCharsets.UTF_8));
            return BinaryUtils.toHex((byte[])sha1.digest()).toLowerCase(Locale.ENGLISH);
        }
        catch (NoSuchAlgorithmException e) {
            throw SdkClientException.create((String)"Unable to derive cache key", (Throwable)e);
        }
    }
}

