/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.PrincipalType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountAssignment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountAssignment> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(AccountAssignment.getter(AccountAssignment::accountId)).setter(AccountAssignment.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> PERMISSION_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionSetArn").getter(AccountAssignment.getter(AccountAssignment::permissionSetArn)).setter(AccountAssignment.setter(Builder::permissionSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionSetArn").build()}).build();
    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrincipalType").getter(AccountAssignment.getter(AccountAssignment::principalTypeAsString)).setter(AccountAssignment.setter(Builder::principalType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalType").build()}).build();
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrincipalId").getter(AccountAssignment.getter(AccountAssignment::principalId)).setter(AccountAssignment.setter(Builder::principalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, PERMISSION_SET_ARN_FIELD, PRINCIPAL_TYPE_FIELD, PRINCIPAL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountAssignment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String permissionSetArn;
    private final String principalType;
    private final String principalId;

    private AccountAssignment(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.permissionSetArn = builder.permissionSetArn;
        this.principalType = builder.principalType;
        this.principalId = builder.principalId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String permissionSetArn() {
        return this.permissionSetArn;
    }

    public final PrincipalType principalType() {
        return PrincipalType.fromValue(this.principalType);
    }

    public final String principalTypeAsString() {
        return this.principalType;
    }

    public final String principalId() {
        return this.principalId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAssignment)) {
            return false;
        }
        AccountAssignment other = (AccountAssignment)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.permissionSetArn(), other.permissionSetArn()) && Objects.equals(this.principalTypeAsString(), other.principalTypeAsString()) && Objects.equals(this.principalId(), other.principalId());
    }

    public final String toString() {
        return ToString.builder((String)"AccountAssignment").add("AccountId", (Object)this.accountId()).add("PermissionSetArn", (Object)this.permissionSetArn()).add("PrincipalType", (Object)this.principalTypeAsString()).add("PrincipalId", (Object)this.principalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "PermissionSetArn": {
                return Optional.ofNullable(clazz.cast(this.permissionSetArn()));
            }
            case "PrincipalType": {
                return Optional.ofNullable(clazz.cast(this.principalTypeAsString()));
            }
            case "PrincipalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("PermissionSetArn", PERMISSION_SET_ARN_FIELD);
        map.put("PrincipalType", PRINCIPAL_TYPE_FIELD);
        map.put("PrincipalId", PRINCIPAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountAssignment, T> g) {
        return obj -> g.apply((AccountAssignment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String permissionSetArn;
        private String principalType;
        private String principalId;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAssignment model) {
            this.accountId(model.accountId);
            this.permissionSetArn(model.permissionSetArn);
            this.principalType(model.principalType);
            this.principalId(model.principalId);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getPermissionSetArn() {
            return this.permissionSetArn;
        }

        public final void setPermissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
        }

        @Override
        public final Builder permissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
            return this;
        }

        public final String getPrincipalType() {
            return this.principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType == null ? null : principalType.toString());
            return this;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public AccountAssignment build() {
            return new AccountAssignment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountAssignment> {
        public Builder accountId(String var1);

        public Builder permissionSetArn(String var1);

        public Builder principalType(String var1);

        public Builder principalType(PrincipalType var1);

        public Builder principalId(String var1);
    }
}

